/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.connector;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.util.Properties;
import org.shredzone.acme4j.connector.NetworkSettings;
import org.slf4j.LoggerFactory;

public class HttpConnector {
    private static final String USER_AGENT;
    private final NetworkSettings networkSettings;

    public static String defaultUserAgent() {
        return USER_AGENT;
    }

    public HttpConnector(NetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
    }

    public HttpRequest.Builder createRequestBuilder(URL url) {
        try {
            return HttpRequest.newBuilder(url.toURI()).header("User-Agent", USER_AGENT).timeout(this.networkSettings.getTimeout());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid URL", ex);
        }
    }

    public HttpClient.Builder createClientBuilder() {
        HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(this.networkSettings.getTimeout()).proxy(this.networkSettings.getProxySelector());
        if (this.networkSettings.getAuthenticator() != null) {
            builder.authenticator(this.networkSettings.getAuthenticator());
        }
        return builder;
    }

    static {
        StringBuilder agent = new StringBuilder("acme4j");
        try (InputStream in = HttpConnector.class.getResourceAsStream("/org/shredzone/acme4j/version.properties");){
            Properties prop = new Properties();
            prop.load(in);
            agent.append('/').append(prop.getProperty("version"));
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(HttpConnector.class).warn("Could not read library version", (Throwable)ex);
        }
        agent.append(" Java/").append(System.getProperty("java.version"));
        USER_AGENT = agent.toString();
    }
}

