/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URL;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.shredzone.acme4j.AcmeJsonResource;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewalInfo
extends AcmeJsonResource {
    private static final Logger LOG = LoggerFactory.getLogger(RenewalInfo.class);

    protected RenewalInfo(Login login, URL location) {
        super(login, location);
    }

    public Instant getSuggestedWindowStart() {
        return this.getJSON().get("suggestedWindow").asObject().get("start").asInstant();
    }

    public Instant getSuggestedWindowEnd() {
        return this.getJSON().get("suggestedWindow").asObject().get("end").asInstant();
    }

    public Optional<URL> getExplanation() {
        return this.getJSON().get("explanationURL").optional().map(JSON.Value::asURL);
    }

    public boolean renewalIsNotRequired(Instant instant) {
        this.assertValidTimeWindow();
        return instant.isBefore(this.getSuggestedWindowStart());
    }

    public boolean renewalIsRecommended(Instant instant) {
        this.assertValidTimeWindow();
        return !instant.isBefore(this.getSuggestedWindowStart()) && instant.isBefore(this.getSuggestedWindowEnd());
    }

    public boolean renewalIsOverdue(Instant instant) {
        this.assertValidTimeWindow();
        return !instant.isBefore(this.getSuggestedWindowEnd());
    }

    public Optional<Instant> getRandomProposal(@Nullable TemporalAmount frequency) {
        this.assertValidTimeWindow();
        Instant start = Instant.now();
        Instant suggestedStart = this.getSuggestedWindowStart();
        if (start.isBefore(suggestedStart)) {
            start = suggestedStart;
        }
        Instant end = this.getSuggestedWindowEnd();
        if (frequency != null) {
            end = end.minus(frequency);
        }
        if (!end.isAfter(start)) {
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochMilli(ThreadLocalRandom.current().nextLong(start.toEpochMilli(), end.toEpochMilli())));
    }

    private void assertValidTimeWindow() {
        if (this.getSuggestedWindowStart().isAfter(this.getSuggestedWindowEnd())) {
            throw new AcmeProtocolException("Received an invalid suggested window");
        }
    }

    @Override
    public Optional<Instant> fetch() throws AcmeException {
        LOG.debug("update RenewalInfo");
        try (Connection conn = this.getSession().connect();){
            conn.sendRequest(this.getLocation(), this.getSession(), null);
            this.setJSON(conn.readJsonResponse());
            Optional<Instant> retryAfterOpt = conn.getRetryAfter();
            retryAfterOpt.ifPresent(instant -> LOG.debug("Retry-After: {}", instant));
            this.setRetryAfter(retryAfterOpt.orElse(null));
            Optional<Instant> optional = retryAfterOpt;
            return optional;
        }
    }
}

