/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.interfaces.ECKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.toolbox.AcmeUtils;

public class CSRBuilder {
    private static final String SIGNATURE_ALG = "SHA256withRSA";
    private static final String EC_SIGNATURE_ALG = "SHA256withECDSA";
    private final X500NameBuilder namebuilder = new X500NameBuilder(X500Name.getDefaultStyle());
    private final List<String> namelist = new ArrayList<String>();
    private final List<InetAddress> iplist = new ArrayList<InetAddress>();
    @Nullable
    private PKCS10CertificationRequest csr = null;

    public void addDomain(String domain) {
        String ace = AcmeUtils.toAce((String)Objects.requireNonNull(domain));
        if (this.namelist.isEmpty()) {
            this.namebuilder.addRDN(BCStyle.CN, ace);
        }
        this.namelist.add(ace);
    }

    public void addDomains(Collection<String> domains) {
        domains.forEach(this::addDomain);
    }

    public void addDomains(String ... domains) {
        Arrays.stream(domains).forEach(this::addDomain);
    }

    public void addIP(InetAddress address) {
        this.iplist.add(Objects.requireNonNull(address));
    }

    public void addIPs(Collection<InetAddress> ips) {
        ips.forEach(this::addIP);
    }

    public void addIPs(InetAddress ... ips) {
        Arrays.stream(ips).forEach(this::addIP);
    }

    public void addIdentifier(Identifier id) {
        Objects.requireNonNull(id);
        if ("dns".equals(id.getType())) {
            this.addDomain(id.getDomain());
        } else if ("ip".equals(id.getType())) {
            this.addIP(id.getIP());
        } else {
            throw new IllegalArgumentException("Unknown identifier type: " + id.getType());
        }
    }

    public void addIdentifiers(Collection<Identifier> ids) {
        ids.forEach(this::addIdentifier);
    }

    public void addIdentifiers(Identifier ... ids) {
        Arrays.stream(ids).forEach(this::addIdentifier);
    }

    public void setOrganization(String o) {
        this.namebuilder.addRDN(BCStyle.O, Objects.requireNonNull(o));
    }

    public void setOrganizationalUnit(String ou) {
        this.namebuilder.addRDN(BCStyle.OU, Objects.requireNonNull(ou));
    }

    public void setLocality(String l) {
        this.namebuilder.addRDN(BCStyle.L, Objects.requireNonNull(l));
    }

    public void setState(String st) {
        this.namebuilder.addRDN(BCStyle.ST, Objects.requireNonNull(st));
    }

    public void setCountry(String c) {
        this.namebuilder.addRDN(BCStyle.C, Objects.requireNonNull(c));
    }

    public void sign(KeyPair keypair) throws IOException {
        Objects.requireNonNull(keypair, "keypair");
        if (this.namelist.isEmpty() && this.iplist.isEmpty()) {
            throw new IllegalStateException("No domain or IP address was set");
        }
        try {
            int ix = 0;
            GeneralName[] gns = new GeneralName[this.namelist.size() + this.iplist.size()];
            for (String name : this.namelist) {
                gns[ix++] = new GeneralName(2, name);
            }
            for (InetAddress ip : this.iplist) {
                gns[ix++] = new GeneralName(7, ip.getHostAddress());
            }
            GeneralNames subjectAltName = new GeneralNames(gns);
            JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(this.namebuilder.build(), keypair.getPublic());
            ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
            extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltName);
            p10Builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensionsGenerator.generate());
            PrivateKey pk = keypair.getPrivate();
            JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(pk instanceof ECKey ? EC_SIGNATURE_ALG : SIGNATURE_ALG);
            ContentSigner signer = csBuilder.build(pk);
            this.csr = p10Builder.build(signer);
        }
        catch (OperatorCreationException ex) {
            throw new IOException("Could not generate CSR", ex);
        }
    }

    public PKCS10CertificationRequest getCSR() {
        if (this.csr == null) {
            throw new IllegalStateException("sign CSR first");
        }
        return this.csr;
    }

    public byte[] getEncoded() throws IOException {
        return this.getCSR().getEncoded();
    }

    public void write(Writer w) throws IOException {
        if (this.csr == null) {
            throw new IllegalStateException("sign CSR first");
        }
        try (PemWriter pw = new PemWriter(w);){
            pw.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE REQUEST", this.getEncoded()));
        }
    }

    public void write(OutputStream out) throws IOException {
        this.write(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.namebuilder.build());
        if (!this.namelist.isEmpty()) {
            sb.append(this.namelist.stream().collect(Collectors.joining(",DNS=", ",DNS=", "")));
        }
        if (!this.iplist.isEmpty()) {
            sb.append(this.iplist.stream().map(InetAddress::getHostAddress).collect(Collectors.joining(",IP=", ",IP=", "")));
        }
        return sb.toString();
    }
}

