/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.param;

import org.shredzone.commons.suncalc.util.ExtendedMath;

public interface LocationParameter<T> {
    public T latitude(double var1);

    public T longitude(double var1);

    public T elevation(double var1);

    default public T elevationFt(double ft) {
        return this.elevation(ft * 0.3048);
    }

    @Deprecated
    default public T height(double h) {
        return this.elevation(h);
    }

    @Deprecated
    default public T heightFt(double ft) {
        return this.elevationFt(ft);
    }

    default public T at(double lat, double lng) {
        this.latitude(lat);
        this.longitude(lng);
        return (T)this;
    }

    default public T at(double[] coords) {
        if (coords.length != 2 && coords.length != 3) {
            throw new IllegalArgumentException("Array must contain 2 or 3 doubles");
        }
        if (coords.length == 3) {
            this.elevation(coords[2]);
        }
        return this.at(coords[0], coords[1]);
    }

    default public T latitude(int d, int m, double s) {
        return this.latitude(ExtendedMath.dms(d, m, s));
    }

    default public T longitude(int d, int m, double s) {
        return this.longitude(ExtendedMath.dms(d, m, s));
    }

    public T sameLocationAs(LocationParameter<?> var1);
}

