/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.util;

import org.shredzone.commons.suncalc.util.ExtendedMath;
import org.shredzone.commons.suncalc.util.JulianDate;
import org.shredzone.commons.suncalc.util.Matrix;
import org.shredzone.commons.suncalc.util.Vector;

public final class Moon {
    private static final double MOON_MEAN_RADIUS = 1737.1;

    private Moon() {
    }

    public static Vector positionEquatorial(JulianDate date) {
        double T = date.getJulianCentury();
        double L0 = ExtendedMath.frac(0.606433 + 1336.855225 * T);
        double l = Math.PI * 2 * ExtendedMath.frac(0.374897 + 1325.55241 * T);
        double ls = Math.PI * 2 * ExtendedMath.frac(0.993133 + 99.997361 * T);
        double D = Math.PI * 2 * ExtendedMath.frac(0.827361 + 1236.853086 * T);
        double F = Math.PI * 2 * ExtendedMath.frac(0.259086 + 1342.227825 * T);
        double D2 = 2.0 * D;
        double l2 = 2.0 * l;
        double F2 = 2.0 * F;
        double dL = 22640.0 * Math.sin(l) - 4586.0 * Math.sin(l - D2) + 2370.0 * Math.sin(D2) + 769.0 * Math.sin(l2) - 668.0 * Math.sin(ls) - 412.0 * Math.sin(F2) - 212.0 * Math.sin(l2 - D2) - 206.0 * Math.sin(l + ls - D2) + 192.0 * Math.sin(l + D2) - 165.0 * Math.sin(ls - D2) - 125.0 * Math.sin(D) - 110.0 * Math.sin(l + ls) + 148.0 * Math.sin(l - ls) - 55.0 * Math.sin(F2 - D2);
        double S = F + (dL + 412.0 * Math.sin(F2) + 541.0 * Math.sin(ls)) / ExtendedMath.ARCS;
        double h = F - D2;
        double N = -526.0 * Math.sin(h) + 44.0 * Math.sin(l + h) - 31.0 * Math.sin(-l + h) - 23.0 * Math.sin(ls + h) + 11.0 * Math.sin(-ls + h) - 25.0 * Math.sin(-l2 + F) + 21.0 * Math.sin(-l + F);
        double l_Moon = Math.PI * 2 * ExtendedMath.frac(L0 + dL / 1296000.0);
        double b_Moon = (18520.0 * Math.sin(S) + N) / ExtendedMath.ARCS;
        double dt = 385000.5584 - 20905.355 * Math.cos(l) - 3699.1109 * Math.cos(D2 - l) - 2955.9676 * Math.cos(D2) - 569.9251 * Math.cos(l2);
        return Vector.ofPolar(l_Moon, b_Moon, dt);
    }

    public static Vector position(JulianDate date) {
        Matrix rotateMatrix = ExtendedMath.equatorialToEcliptical(date).transpose();
        return rotateMatrix.multiply(Moon.positionEquatorial(date));
    }

    public static Vector positionHorizontal(JulianDate date, double lat, double lng) {
        Vector mc = Moon.position(date);
        double h = date.getGreenwichMeanSiderealTime() + lng - mc.getPhi();
        return ExtendedMath.equatorialToHorizontal(h, mc.getTheta(), mc.getR(), lat);
    }

    public static Vector positionTopocentric(JulianDate date, double lat, double lng, double elev) {
        Vector pos = Moon.positionHorizontal(date, lat, lng);
        return Vector.ofPolar(pos.getPhi(), pos.getTheta() - ExtendedMath.parallax(elev, pos.getR()), pos.getR());
    }

    public static double angularRadius(double distance) {
        return Math.asin(1737.1 / distance);
    }
}

