/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc;

import org.shredzone.commons.suncalc.MoonPhase;
import org.shredzone.commons.suncalc.param.Builder;
import org.shredzone.commons.suncalc.param.GenericParameter;
import org.shredzone.commons.suncalc.param.TimeParameter;
import org.shredzone.commons.suncalc.util.BaseBuilder;
import org.shredzone.commons.suncalc.util.JulianDate;
import org.shredzone.commons.suncalc.util.Moon;
import org.shredzone.commons.suncalc.util.Sun;
import org.shredzone.commons.suncalc.util.Vector;

public class MoonIllumination {
    private final double fraction;
    private final double phase;
    private final double angle;

    private MoonIllumination(double fraction, double phase, double angle) {
        this.fraction = fraction;
        this.phase = phase;
        this.angle = angle;
    }

    public static Parameters compute() {
        return new MoonIlluminationBuilder();
    }

    public double getFraction() {
        return this.fraction;
    }

    public double getPhase() {
        return this.phase;
    }

    public double getAngle() {
        return this.angle;
    }

    public MoonPhase.Phase getClosestPhase() {
        return MoonPhase.Phase.toPhase(this.phase + 180.0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MoonIllumination[fraction=").append(this.fraction);
        sb.append(", phase=").append(this.phase);
        sb.append("\u00b0, angle=").append(this.angle);
        sb.append("\u00b0]");
        return sb.toString();
    }

    private static class MoonIlluminationBuilder
    extends BaseBuilder<Parameters>
    implements Parameters {
        private MoonIlluminationBuilder() {
        }

        @Override
        public MoonIllumination execute() {
            JulianDate t = this.getJulianDate();
            Vector s = Sun.position(t);
            Vector m = Moon.position(t);
            double phi = Math.PI - Math.acos(m.dot(s) / (m.getR() * s.getR()));
            Vector sunMoon = m.cross(s);
            return new MoonIllumination((1.0 + Math.cos(phi)) / 2.0, Math.toDegrees(phi * Math.signum(sunMoon.getTheta())), Math.toDegrees(sunMoon.getTheta()));
        }
    }

    public static interface Parameters
    extends GenericParameter<Parameters>,
    TimeParameter<Parameters>,
    Builder<MoonIllumination> {
    }
}

