/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc;

import java.time.ZonedDateTime;
import org.shredzone.commons.suncalc.param.Builder;
import org.shredzone.commons.suncalc.param.GenericParameter;
import org.shredzone.commons.suncalc.param.TimeParameter;
import org.shredzone.commons.suncalc.util.BaseBuilder;
import org.shredzone.commons.suncalc.util.JulianDate;
import org.shredzone.commons.suncalc.util.Moon;
import org.shredzone.commons.suncalc.util.Pegasus;
import org.shredzone.commons.suncalc.util.Sun;
import org.shredzone.commons.suncalc.util.Vector;

public class MoonPhase {
    private final ZonedDateTime time;
    private final double distance;

    private MoonPhase(ZonedDateTime time, double distance) {
        this.time = time;
        this.distance = distance;
    }

    public static Parameters compute() {
        return new MoonPhaseBuilder();
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean isSuperMoon() {
        return this.distance < 360000.0;
    }

    public boolean isMicroMoon() {
        return this.distance > 405000.0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MoonPhase[time=").append(this.time);
        sb.append(", distance=").append(this.distance);
        sb.append(" km]");
        return sb.toString();
    }

    private static class MoonPhaseBuilder
    extends BaseBuilder<Parameters>
    implements Parameters {
        private static final double SUN_LIGHT_TIME_TAU = 1.5818693436763253E-7;
        private double phase = Phase.NEW_MOON.getAngleRad();

        private MoonPhaseBuilder() {
        }

        @Override
        public Parameters phase(Phase phase) {
            this.phase = phase.getAngleRad();
            return this;
        }

        @Override
        public Parameters phase(double phase) {
            this.phase = Math.toRadians(phase);
            return this;
        }

        @Override
        public MoonPhase execute() {
            JulianDate jd = this.getJulianDate();
            double dT = 1.916495550992471E-4;
            double accuracy = 9.506426344208685E-9;
            double t0 = jd.getJulianCentury();
            double t1 = t0 + dT;
            double d0 = this.moonphase(jd, t0);
            double d1 = this.moonphase(jd, t1);
            while (d0 * d1 > 0.0 || d1 < d0) {
                t0 = t1;
                d0 = d1;
                d1 = this.moonphase(jd, t1 += dT);
            }
            double tphase = Pegasus.calculate(t0, t1, accuracy, x -> this.moonphase(jd, (double)x));
            JulianDate tjd = jd.atJulianCentury(tphase);
            return new MoonPhase(tjd.getDateTime(), Moon.positionEquatorial(tjd).getR());
        }

        private double moonphase(JulianDate jd, double t) {
            double diff;
            Vector sun = Sun.positionEquatorial(jd.atJulianCentury(t - 1.5818693436763253E-7));
            Vector moon = Moon.positionEquatorial(jd.atJulianCentury(t));
            for (diff = moon.getPhi() - sun.getPhi() - this.phase; diff < 0.0; diff += Math.PI * 2) {
            }
            return (diff + Math.PI) % (Math.PI * 2) - Math.PI;
        }
    }

    public static enum Phase {
        NEW_MOON(0.0),
        WAXING_CRESCENT(45.0),
        FIRST_QUARTER(90.0),
        WAXING_GIBBOUS(135.0),
        FULL_MOON(180.0),
        WANING_GIBBOUS(225.0),
        LAST_QUARTER(270.0),
        WANING_CRESCENT(315.0);

        private final double angle;
        private final double angleRad;

        public static Phase toPhase(double angle) {
            double normalized = angle % 360.0;
            if (normalized < 0.0) {
                normalized += 360.0;
            }
            if (normalized < 22.5) {
                return NEW_MOON;
            }
            if (normalized < 67.5) {
                return WAXING_CRESCENT;
            }
            if (normalized < 112.5) {
                return FIRST_QUARTER;
            }
            if (normalized < 157.5) {
                return WAXING_GIBBOUS;
            }
            if (normalized < 202.5) {
                return FULL_MOON;
            }
            if (normalized < 247.5) {
                return WANING_GIBBOUS;
            }
            if (normalized < 292.5) {
                return LAST_QUARTER;
            }
            if (normalized < 337.5) {
                return WANING_CRESCENT;
            }
            return NEW_MOON;
        }

        private Phase(double angle) {
            this.angle = angle;
            this.angleRad = Math.toRadians(angle);
        }

        public double getAngle() {
            return this.angle;
        }

        public double getAngleRad() {
            return this.angleRad;
        }
    }

    public static interface Parameters
    extends GenericParameter<Parameters>,
    TimeParameter<Parameters>,
    Builder<MoonPhase> {
        public Parameters phase(Phase var1);

        public Parameters phase(double var1);
    }
}

