/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.ZonedDateTime;
import org.shredzone.commons.suncalc.param.Builder;
import org.shredzone.commons.suncalc.param.GenericParameter;
import org.shredzone.commons.suncalc.param.LocationParameter;
import org.shredzone.commons.suncalc.param.TimeParameter;
import org.shredzone.commons.suncalc.util.BaseBuilder;
import org.shredzone.commons.suncalc.util.ExtendedMath;
import org.shredzone.commons.suncalc.util.JulianDate;
import org.shredzone.commons.suncalc.util.QuadraticInterpolation;
import org.shredzone.commons.suncalc.util.Sun;
import org.shredzone.commons.suncalc.util.Vector;

public class SunTimes {
    @Nullable
    private final ZonedDateTime rise;
    @Nullable
    private final ZonedDateTime set;
    @Nullable
    private final ZonedDateTime noon;
    @Nullable
    private final ZonedDateTime nadir;
    private final boolean alwaysUp;
    private final boolean alwaysDown;

    private SunTimes(@Nullable ZonedDateTime rise, @Nullable ZonedDateTime set, @Nullable ZonedDateTime noon, @Nullable ZonedDateTime nadir, boolean alwaysUp, boolean alwaysDown) {
        this.rise = rise;
        this.set = set;
        this.noon = noon;
        this.nadir = nadir;
        this.alwaysUp = alwaysUp;
        this.alwaysDown = alwaysDown;
    }

    public static Parameters compute() {
        return new SunTimesBuilder();
    }

    @Nullable
    public ZonedDateTime getRise() {
        return this.rise;
    }

    @Nullable
    public ZonedDateTime getSet() {
        return this.set;
    }

    @Nullable
    public ZonedDateTime getNoon() {
        return this.noon;
    }

    @Nullable
    public ZonedDateTime getNadir() {
        return this.nadir;
    }

    public boolean isAlwaysUp() {
        return this.alwaysUp;
    }

    public boolean isAlwaysDown() {
        return this.alwaysDown;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SunTimes[rise=").append(this.rise);
        sb.append(", set=").append(this.set);
        sb.append(", noon=").append(this.noon);
        sb.append(", nadir=").append(this.nadir);
        sb.append(", alwaysUp=").append(this.alwaysUp);
        sb.append(", alwaysDown=").append(this.alwaysDown);
        sb.append(']');
        return sb.toString();
    }

    private static class SunTimesBuilder
    extends BaseBuilder<Parameters>
    implements Parameters {
        private double angle = Twilight.VISUAL.getAngleRad();
        @Nullable
        private Double position = Twilight.access$100(Twilight.VISUAL);
        private Duration limit = Duration.ofDays(365L);

        private SunTimesBuilder() {
        }

        @Override
        public Parameters twilight(Twilight twilight) {
            this.angle = twilight.getAngleRad();
            this.position = twilight.getAngularPosition();
            return this;
        }

        @Override
        public Parameters twilight(double angle) {
            this.angle = Math.toRadians(angle);
            this.position = null;
            return this;
        }

        @Override
        public Parameters limit(Duration duration) {
            if (duration == null || duration.isNegative()) {
                throw new IllegalArgumentException("duration must be positive");
            }
            this.limit = duration;
            return this;
        }

        @Override
        public SunTimes execute() {
            JulianDate jd = this.getJulianDate();
            Double rise = null;
            Double set = null;
            Double noon = null;
            Double nadir = null;
            boolean alwaysUp = false;
            boolean alwaysDown = false;
            int hour = 0;
            double limitHours = (double)this.limit.toMillis() / 3600000.0;
            int maxHours = (int)Math.ceil(limitHours);
            double y_minus = this.correctedSunHeight(jd.atHour((double)hour - 1.0));
            double y_0 = this.correctedSunHeight(jd.atHour(hour));
            double y_plus = this.correctedSunHeight(jd.atHour((double)hour + 1.0));
            if (y_0 > 0.0) {
                alwaysUp = true;
            } else {
                alwaysDown = true;
            }
            while (hour <= maxHours) {
                double xeHour;
                double rt;
                QuadraticInterpolation qi = new QuadraticInterpolation(y_minus, y_0, y_plus);
                double ye = qi.getYe();
                if (qi.getNumberOfRoots() == 1) {
                    rt = qi.getRoot1() + (double)hour;
                    if (y_minus < 0.0) {
                        if (rise == null && rt >= 0.0 && rt < limitHours) {
                            rise = rt;
                            alwaysDown = false;
                        }
                    } else if (set == null && rt >= 0.0 && rt < limitHours) {
                        set = rt;
                        alwaysUp = false;
                    }
                } else if (qi.getNumberOfRoots() == 2) {
                    if (rise == null && (rt = (double)hour + (ye < 0.0 ? qi.getRoot2() : qi.getRoot1())) >= 0.0 && rt < limitHours) {
                        rise = rt;
                        alwaysDown = false;
                    }
                    if (set == null && (rt = (double)hour + (ye < 0.0 ? qi.getRoot1() : qi.getRoot2())) >= 0.0 && rt < limitHours) {
                        set = rt;
                        alwaysUp = false;
                    }
                }
                double xeAbs = Math.abs(qi.getXe());
                if (xeAbs <= 1.0 && (xeHour = qi.getXe() + (double)hour) >= 0.0) {
                    if (qi.isMaximum()) {
                        if (noon == null) {
                            noon = xeHour;
                        }
                    } else if (nadir == null) {
                        nadir = xeHour;
                    }
                }
                if (rise != null && set != null && noon != null && nadir != null) break;
                y_minus = y_0;
                y_0 = y_plus;
                y_plus = this.correctedSunHeight(jd.atHour((double)(++hour) + 1.0));
            }
            if (noon != null && ((noon = Double.valueOf(ExtendedMath.readjustMax(noon, 2.0, 14, t -> this.correctedSunHeight(jd.atHour((double)t))))) < 0.0 || noon >= limitHours)) {
                noon = null;
            }
            if (nadir != null && ((nadir = Double.valueOf(ExtendedMath.readjustMin(nadir, 2.0, 14, t -> this.correctedSunHeight(jd.atHour((double)t))))) < 0.0 || nadir >= limitHours)) {
                nadir = null;
            }
            return new SunTimes(rise != null ? jd.atHour(rise).getDateTime() : null, set != null ? jd.atHour(set).getDateTime() : null, noon != null ? jd.atHour(noon).getDateTime() : null, nadir != null ? jd.atHour(nadir).getDateTime() : null, alwaysUp, alwaysDown);
        }

        private double correctedSunHeight(JulianDate jd) {
            Vector pos = Sun.positionHorizontal(jd, this.getLatitudeRad(), this.getLongitudeRad());
            double hc = this.angle;
            if (this.position != null) {
                hc -= ExtendedMath.apparentRefraction(hc);
                hc += ExtendedMath.parallax(this.getHeight(), pos.getR());
                hc -= this.position * Sun.angularRadius(pos.getR());
            }
            return pos.getTheta() - hc;
        }
    }

    public static enum Twilight {
        VISUAL(0.0, 1.0),
        VISUAL_LOWER(0.0, -1.0),
        HORIZON(0.0),
        CIVIL(-6.0),
        NAUTICAL(-12.0),
        ASTRONOMICAL(-18.0),
        GOLDEN_HOUR(6.0),
        BLUE_HOUR(-4.0),
        NIGHT_HOUR(-8.0);

        private final double angle;
        private final double angleRad;
        @Nullable
        private final Double position;

        private Twilight(double angle) {
            this(angle, null);
        }

        private Twilight(double angle, Double position) {
            this.angle = angle;
            this.angleRad = Math.toRadians(angle);
            this.position = position;
        }

        public double getAngle() {
            return this.angle;
        }

        public double getAngleRad() {
            return this.angleRad;
        }

        public boolean isTopocentric() {
            return this.position != null;
        }

        @Nullable
        private Double getAngularPosition() {
            return this.position;
        }
    }

    public static interface Parameters
    extends GenericParameter<Parameters>,
    LocationParameter<Parameters>,
    TimeParameter<Parameters>,
    Builder<SunTimes> {
        public Parameters twilight(Twilight var1);

        public Parameters twilight(double var1);

        public Parameters limit(Duration var1);

        default public Parameters oneDay() {
            return this.limit(Duration.ofDays(1L));
        }

        default public Parameters fullCycle() {
            return this.limit(Duration.ofDays(365L));
        }
    }
}

