/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.shredzone.commons.suncalc.param.GenericParameter;
import org.shredzone.commons.suncalc.param.LocationParameter;
import org.shredzone.commons.suncalc.param.TimeParameter;
import org.shredzone.commons.suncalc.util.JulianDate;

public class BaseBuilder<T>
implements GenericParameter<T>,
LocationParameter<T>,
TimeParameter<T>,
Cloneable {
    private double lat = 0.0;
    private double lng = 0.0;
    private double height = 0.0;
    private ZonedDateTime dateTime = ZonedDateTime.now();

    @Override
    public T on(ZonedDateTime dateTime) {
        this.dateTime = Objects.requireNonNull(dateTime, "dateTime");
        return (T)this;
    }

    @Override
    public T on(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime, "dateTime");
        return this.on(ZonedDateTime.of(dateTime, this.dateTime.getZone()));
    }

    @Override
    public T on(LocalDate date) {
        Objects.requireNonNull(date, "date");
        return this.on(ZonedDateTime.of(date, LocalTime.MIDNIGHT, this.dateTime.getZone()));
    }

    @Override
    public T on(Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return this.on(ZonedDateTime.ofInstant(instant, this.dateTime.getZone()));
    }

    @Override
    public T on(int year, int month, int date, int hour, int minute, int second) {
        return this.on(ZonedDateTime.of(year, month, date, hour, minute, second, 0, this.dateTime.getZone()));
    }

    @Override
    public T now() {
        return this.on(ZonedDateTime.now(this.dateTime.getZone()));
    }

    @Override
    public T plusDays(int days) {
        return this.on(this.dateTime.plusDays(days));
    }

    @Override
    public T midnight() {
        return this.on(this.dateTime.truncatedTo(ChronoUnit.DAYS));
    }

    @Override
    public T timezone(ZoneId tz) {
        Objects.requireNonNull(tz, "tz");
        this.on(this.dateTime.withZoneSameLocal(tz));
        return (T)this;
    }

    @Override
    public T latitude(double lat) {
        if (lat < -90.0 || lat > 90.0) {
            throw new IllegalArgumentException("Latitude out of range, -90.0 <= " + lat + " <= 90.0");
        }
        this.lat = lat;
        return (T)this;
    }

    @Override
    public T longitude(double lng) {
        if (lng < -180.0 || lng > 180.0) {
            throw new IllegalArgumentException("Longitude out of range, -180.0 <= " + lng + " <= 180.0");
        }
        this.lng = lng;
        return (T)this;
    }

    @Override
    public T height(double h) {
        this.height = Math.max(h, 0.0);
        return (T)this;
    }

    @Override
    public T sameTimeAs(TimeParameter<?> t) {
        if (!(t instanceof BaseBuilder)) {
            throw new IllegalArgumentException("Cannot read the TimeParameter");
        }
        this.dateTime = ((BaseBuilder)t).dateTime;
        return (T)this;
    }

    @Override
    public T sameLocationAs(LocationParameter<?> l) {
        if (!(l instanceof BaseBuilder)) {
            throw new IllegalArgumentException("Cannot read the LocationParameter");
        }
        BaseBuilder origin = (BaseBuilder)l;
        this.lat = origin.lat;
        this.lng = origin.lng;
        this.height = origin.height;
        return (T)this;
    }

    @Override
    public T copy() {
        try {
            return (T)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public double getLongitude() {
        return this.lng;
    }

    public double getLatitude() {
        return this.lat;
    }

    public double getLongitudeRad() {
        return Math.toRadians(this.lng);
    }

    public double getLatitudeRad() {
        return Math.toRadians(this.lat);
    }

    public double getHeight() {
        return this.height;
    }

    public JulianDate getJulianDate() {
        return new JulianDate(this.dateTime);
    }
}

