/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.util;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.shredzone.commons.suncalc.util.ExtendedMath;

public class JulianDate {
    private final ZonedDateTime dateTime;
    private final double mjd;

    public JulianDate(ZonedDateTime time) {
        this.dateTime = Objects.requireNonNull(time, "time");
        this.mjd = (double)this.dateTime.toInstant().toEpochMilli() / 8.64E7 + 40587.0;
    }

    public JulianDate atHour(double hour) {
        return new JulianDate(this.dateTime.plusSeconds(Math.round(hour * 60.0 * 60.0)));
    }

    public JulianDate atModifiedJulianDate(double mjd) {
        Instant mjdi = Instant.ofEpochMilli(Math.round((mjd - 40587.0) * 8.64E7));
        return new JulianDate(ZonedDateTime.ofInstant(mjdi, this.dateTime.getZone()));
    }

    public JulianDate atJulianCentury(double jc) {
        return this.atModifiedJulianDate(jc * 36525.0 + 51544.5);
    }

    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    public double getModifiedJulianDate() {
        return this.mjd;
    }

    public double getJulianCentury() {
        return (this.mjd - 51544.5) / 36525.0;
    }

    public double getGreenwichMeanSiderealTime() {
        double secs = 86400.0;
        double mjd0 = Math.floor(this.mjd);
        double ut = (this.mjd - mjd0) * 86400.0;
        double t0 = (mjd0 - 51544.5) / 36525.0;
        double t = (this.mjd - 51544.5) / 36525.0;
        double gmst = 24110.54841 + 8640184.812866 * t0 + 1.0027379093 * ut + (0.093104 - 6.2E-6 * t) * t * t;
        return 7.27220521664304E-5 * (gmst % 86400.0);
    }

    public double getTrueAnomaly() {
        return Math.PI * 2 * ExtendedMath.frac(((double)this.dateTime.getDayOfYear() - 5.0) / 365.256363);
    }

    public String toString() {
        return String.format("%dd %02dh %02dm %02ds", (long)this.mjd, (long)(this.mjd * 24.0 % 24.0), (long)(this.mjd * 24.0 * 60.0 % 60.0), (long)(this.mjd * 24.0 * 60.0 * 60.0 % 60.0));
    }
}

