/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.util;

import java.util.function.Function;

public class Pegasus {
    private static final int MAX_ITERATIONS = 30;

    public static Double calculate(double lower, double upper, double accuracy, Function<Double, Double> f) {
        double f2;
        double x1 = lower;
        double x2 = upper;
        double f1 = f.apply(x1);
        if (f1 * (f2 = f.apply(x2).doubleValue()) >= 0.0) {
            throw new ArithmeticException("No root within the given boundaries");
        }
        int i = 30;
        while (i-- > 0) {
            double x3 = x2 - f2 / ((f2 - f1) / (x2 - x1));
            double f3 = f.apply(x3);
            if (f3 * f2 <= 0.0) {
                x1 = x2;
                f1 = f2;
                x2 = x3;
                f2 = f3;
            } else {
                f1 = f1 * f2 / (f2 + f3);
                x2 = x3;
                f2 = f3;
            }
            if (!(Math.abs(x2 - x1) <= accuracy)) continue;
            return Math.abs(f1) < Math.abs(f2) ? x1 : x2;
        }
        throw new ArithmeticException("Maximum number of iterations exceeded");
    }
}

