/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.util;

import org.shredzone.commons.suncalc.util.ExtendedMath;
import org.shredzone.commons.suncalc.util.JulianDate;
import org.shredzone.commons.suncalc.util.Matrix;
import org.shredzone.commons.suncalc.util.Vector;

public final class Sun {
    private static final double SUN_DISTANCE = 1.49598E8;
    private static final double SUN_MEAN_RADIUS = 695700.0;

    private Sun() {
    }

    public static Vector positionEquatorial(JulianDate date) {
        double T = date.getJulianCentury();
        double M = Math.PI * 2 * ExtendedMath.frac(0.993133 + 99.997361 * T);
        double L = Math.PI * 2 * ExtendedMath.frac(0.7859453 + M / (Math.PI * 2) + (6893.0 * Math.sin(M) + 72.0 * Math.sin(2.0 * M) + 6191.2 * T) / 1296000.0);
        double d = 1.49598E8 * (1.0 - 0.016718 * Math.cos(date.getTrueAnomaly()));
        return Vector.ofPolar(L, 0.0, d);
    }

    public static Vector position(JulianDate date) {
        Matrix rotateMatrix = ExtendedMath.equatorialToEcliptical(date).transpose();
        return rotateMatrix.multiply(Sun.positionEquatorial(date));
    }

    public static Vector positionHorizontal(JulianDate date, double lat, double lng) {
        Vector mc = Sun.position(date);
        double h = date.getGreenwichMeanSiderealTime() + lng - mc.getPhi();
        return ExtendedMath.equatorialToHorizontal(h, mc.getTheta(), mc.getR(), lat);
    }

    public static double angularRadius(double distance) {
        return Math.asin(695700.0 / distance);
    }
}

