/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import org.shredzone.commons.suncalc.util.ExtendedMath;

public class Vector {
    private final double x;
    private final double y;
    private final double z;
    private final Polar polar = new Polar();

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(double[] d) {
        if (d.length != 3) {
            throw new IllegalArgumentException("invalid vector length");
        }
        this.x = d[0];
        this.y = d[1];
        this.z = d[2];
    }

    public static Vector ofPolar(double \u03c6, double \u03b8) {
        return Vector.ofPolar(\u03c6, \u03b8, 1.0);
    }

    public static Vector ofPolar(double \u03c6, double \u03b8, double r) {
        double cos\u03b8 = Math.cos(\u03b8);
        Vector result = new Vector(r * Math.cos(\u03c6) * cos\u03b8, r * Math.sin(\u03c6) * cos\u03b8, r * Math.sin(\u03b8));
        result.polar.setPolar(\u03c6, \u03b8, r);
        return result;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getPhi() {
        return this.polar.getPhi();
    }

    public double getTheta() {
        return this.polar.getTheta();
    }

    public double getR() {
        return this.polar.getR();
    }

    public Vector add(Vector vec) {
        return new Vector(this.x + vec.x, this.y + vec.y, this.z + vec.z);
    }

    public Vector subtract(Vector vec) {
        return new Vector(this.x - vec.x, this.y - vec.y, this.z - vec.z);
    }

    public Vector multiply(double scalar) {
        return new Vector(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public Vector negate() {
        return new Vector(-this.x, -this.y, -this.z);
    }

    public Vector cross(Vector right) {
        return new Vector(this.y * right.z - this.z * right.y, this.z * right.x - this.x * right.z, this.x * right.y - this.y * right.x);
    }

    public double dot(Vector right) {
        return this.x * right.x + this.y * right.y + this.z * right.z;
    }

    public double norm() {
        return Math.sqrt(this.dot(this));
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Vector)) {
            return false;
        }
        Vector vec = (Vector)obj;
        return Double.compare(this.x, vec.x) == 0 && Double.compare(this.y, vec.y) == 0 && Double.compare(this.z, vec.z) == 0;
    }

    public int hashCode() {
        return Double.valueOf(this.x).hashCode() ^ Double.valueOf(this.y).hashCode() ^ Double.valueOf(this.z).hashCode();
    }

    public String toString() {
        return "(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    private class Polar {
        @Nullable
        private Double \u03c6 = null;
        @Nullable
        private Double \u03b8 = null;
        @Nullable
        private Double r = null;

        private Polar() {
        }

        public synchronized void setPolar(double \u03c6, double \u03b8, double r) {
            this.\u03c6 = \u03c6;
            this.\u03b8 = \u03b8;
            this.r = r;
        }

        public synchronized double getPhi() {
            if (this.\u03c6 == null) {
                this.\u03c6 = ExtendedMath.isZero(Vector.this.x) && ExtendedMath.isZero(Vector.this.y) ? Double.valueOf(0.0) : Double.valueOf(Math.atan2(Vector.this.y, Vector.this.x));
                if (this.\u03c6 < 0.0) {
                    this.\u03c6 = this.\u03c6 + Math.PI * 2;
                }
            }
            return this.\u03c6;
        }

        public synchronized double getTheta() {
            if (this.\u03b8 == null) {
                double \u03c1Sqr = Vector.this.x * Vector.this.x + Vector.this.y * Vector.this.y;
                this.\u03b8 = ExtendedMath.isZero(Vector.this.z) && ExtendedMath.isZero(\u03c1Sqr) ? Double.valueOf(0.0) : Double.valueOf(Math.atan2(Vector.this.z, Math.sqrt(\u03c1Sqr)));
            }
            return this.\u03b8;
        }

        public synchronized double getR() {
            if (this.r == null) {
                this.r = Math.sqrt(Vector.this.x * Vector.this.x + Vector.this.y * Vector.this.y + Vector.this.z * Vector.this.z);
            }
            return this.r;
        }
    }
}

