/*
 * Decompiled with CFR 0.152.
 */
package org.signal.aesgcmprovider;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import org.signal.aesgcmprovider.ReserveBuffer;

public class AesGcmCipher
extends CipherSpi {
    private GCMParameterSpec algorithmParameterSpec;
    private long cipherContext;
    private boolean encrypt;
    private ReserveBuffer reserveBuffer;

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!"GCM".equals(mode)) {
            throw new NoSuchAlgorithmException();
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!"NoPadding".equals(padding)) {
            throw new NoSuchPaddingException();
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return inputLen + this.algorithmParameterSpec.getTLen() / 8;
    }

    @Override
    protected byte[] engineGetIV() {
        return this.algorithmParameterSpec.getIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("GCM");
            parameters.init(this.algorithmParameterSpec);
            return parameters;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidKeyException {
        try {
            this.engineInit(opmode, key, params.getParameterSpec(GCMParameterSpec.class), random);
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException(e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (params == null && opmode == 2) {
            throw new InvalidAlgorithmParameterException("Required GCMParameterSpec for decryption");
        }
        if (params == null) {
            byte[] iv = new byte[12];
            random.nextBytes(iv);
            params = new GCMParameterSpec(128, iv);
        } else if (!(params instanceof GCMParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Required GCMParameterSpec");
        }
        if (((GCMParameterSpec)params).getIV().length != 12) {
            throw new InvalidAlgorithmParameterException("Only IV of 12 is supported");
        }
        if (key.getEncoded().length != 16 && key.getEncoded().length != 32) {
            throw new InvalidAlgorithmParameterException("Only keys of 16 bytes or 32 bytes are supported");
        }
        this.algorithmParameterSpec = (GCMParameterSpec)params;
        this.encrypt = opmode == 1;
        this.cipherContext = this.initializeCipher(this.encrypt, key.getEncoded(), key.getEncoded().length, ((GCMParameterSpec)params).getIV());
        if (!this.encrypt) {
            this.reserveBuffer = new ReserveBuffer(((GCMParameterSpec)params).getTLen() / 8);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (input == null) {
            return new byte[0];
        }
        if (this.encrypt) {
            byte[] output = new byte[inputLen];
            this.update(this.cipherContext, input, inputOffset, inputLen, output, 0, output.length);
            return output;
        }
        byte[] allocatedInput = this.reserveBuffer.update(input, inputOffset, inputLen);
        byte[] output = new byte[allocatedInput.length];
        this.update(this.cipherContext, allocatedInput, 0, allocatedInput.length, output, 0, output.length);
        return output;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        byte[] allocatedOutput = this.engineUpdate(input, inputOffset, inputLen);
        if (allocatedOutput.length > output.length - outputOffset) {
            throw new ShortBufferException("Needed: " + allocatedOutput.length + " but provided: " + (output.length - outputOffset));
        }
        System.arraycopy(allocatedOutput, 0, output, outputOffset, allocatedOutput.length);
        return allocatedOutput.length;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws BadPaddingException, IllegalBlockSizeException {
        byte[] ciphertext = this.engineUpdate(input, inputOffset, inputLen);
        if (this.encrypt) {
            byte[] tag = new byte[this.algorithmParameterSpec.getTLen() / 8];
            this.finishEncrypt(this.cipherContext, tag, tag.length);
            byte[] combined = new byte[ciphertext.length + tag.length];
            System.arraycopy(ciphertext, 0, combined, 0, ciphertext.length);
            System.arraycopy(tag, 0, combined, ciphertext.length, tag.length);
            return combined;
        }
        if (this.reserveBuffer.getAvailable() != this.algorithmParameterSpec.getTLen() / 8) {
            throw new BadPaddingException("Original ciphertext shorter than tag length");
        }
        byte[] tag = new byte[this.algorithmParameterSpec.getTLen() / 8];
        this.reserveBuffer.read(tag, 0, tag.length);
        if (!this.finishDecrypt(this.cipherContext, tag, tag.length)) {
            throw new BadPaddingException("Incorrect tag!");
        }
        return ciphertext;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        byte[] allocatedOutput = this.engineDoFinal(input, inputOffset, inputLen);
        if (allocatedOutput.length > output.length - outputOffset) {
            throw new ShortBufferException("Needed: " + allocatedOutput.length + " but provided: " + (output.length - outputOffset));
        }
        System.arraycopy(allocatedOutput, 0, output, outputOffset, allocatedOutput.length);
        return allocatedOutput.length;
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) {
        this.updateAAD(this.cipherContext, src, offset, len);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer src) {
        int aadLen;
        if (src != null && (aadLen = src.limit() - src.position()) > 0) {
            if (src.hasArray()) {
                int aadOfs = AesGcmCipher.addExact(src.arrayOffset(), src.position());
                this.updateAAD(this.cipherContext, src.array(), aadOfs, aadLen);
                src.position(src.limit());
            } else {
                byte[] aad = new byte[aadLen];
                src.get(aad);
                this.updateAAD(this.cipherContext, aad, 0, aadLen);
            }
        }
    }

    private static int addExact(int x, int y) {
        int r = x + y;
        if (((x ^ r) & (y ^ r)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return r;
    }

    protected void finalize() {
        if (this.cipherContext != 0L) {
            this.destroy(this.cipherContext);
        }
    }

    private native long initializeCipher(boolean var1, byte[] var2, int var3, byte[] var4);

    private native void updateAAD(long var1, byte[] var3, int var4, int var5);

    private native void update(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    private native void finishEncrypt(long var1, byte[] var3, int var4);

    private native boolean finishDecrypt(long var1, byte[] var3, int var4);

    private native void destroy(long var1);
}

