/*
 * Decompiled with CFR 0.152.
 */
package org.signal.aesgcmprovider;

class ReserveBuffer {
    private final byte[] reserve;
    private int writePointer = 0;
    private int available = 0;

    ReserveBuffer(int sizeInBytes) {
        this.reserve = new byte[sizeInBytes];
    }

    public byte[] update(byte[] input, int offset, int inputLength) {
        int reserveToApply = Math.min(this.reserve.length, inputLength);
        int reserveToRelease = Math.max(reserveToApply - this.capacity(), 0);
        byte[] output = new byte[reserveToRelease + (inputLength - reserveToApply)];
        this.read(output, 0, reserveToRelease);
        System.arraycopy(input, offset, output, reserveToRelease, inputLength - reserveToApply);
        this.write(input, offset + (inputLength - reserveToApply), reserveToApply);
        return output;
    }

    private void write(byte[] buffer, int offset, int length) {
        int remainingToEnd = this.reserve.length - this.writePointer;
        int amountToCopy = Math.min(remainingToEnd, length);
        System.arraycopy(buffer, offset, this.reserve, this.writePointer, amountToCopy);
        System.arraycopy(buffer, offset + amountToCopy, this.reserve, 0, length - amountToCopy);
        this.writePointer = (this.writePointer + length) % this.reserve.length;
        this.available += length;
    }

    public void read(byte[] buffer, int offset, int length) {
        int startPosition = this.writePointer - this.available;
        if (startPosition < 0) {
            startPosition += this.reserve.length;
        }
        int remainingToEnd = this.reserve.length - startPosition;
        int amountToCopy = Math.min(remainingToEnd, length);
        System.arraycopy(this.reserve, startPosition, buffer, offset, amountToCopy);
        System.arraycopy(this.reserve, 0, buffer, offset + amountToCopy, length - amountToCopy);
        this.available -= length;
    }

    public int capacity() {
        return this.reserve.length - this.available;
    }

    public int getAvailable() {
        return this.available;
    }
}

