/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import redis.embedded.AbstractRedisInstance;
import redis.embedded.RedisExecProvider;
import redis.embedded.RedisServerBuilder;

public class RedisServer
extends AbstractRedisInstance {
    private static final String REDIS_READY_PATTERN = ".*(R|r)eady to accept connections.*";
    private static final int DEFAULT_REDIS_PORT = 6379;

    public RedisServer() {
        this(6379);
    }

    public RedisServer(int port) {
        super(port);
        this.args = RedisServer.builder().port((int)port).build().args;
    }

    public RedisServer(int port, int tlsPort) {
        super(port, tlsPort);
        this.args = RedisServer.builder().port((int)port).tlsPort((int)tlsPort).build().args;
    }

    public RedisServer(File executable, int port) {
        super(port);
        this.args = Arrays.asList(executable.getAbsolutePath(), "--port", Integer.toString(port));
    }

    public RedisServer(RedisExecProvider redisExecProvider, int port) throws IOException {
        super(port);
        this.args = Arrays.asList(redisExecProvider.get().getAbsolutePath(), "--port", Integer.toString(port));
    }

    RedisServer(List<String> args, int port, int tlsPort) {
        super(port, tlsPort);
        this.args = new ArrayList<String>(args);
    }

    public static RedisServerBuilder builder() {
        return new RedisServerBuilder();
    }

    @Override
    protected String redisReadyPattern() {
        return REDIS_READY_PATTERN;
    }
}

