/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import redis.embedded.exceptions.OsDetectionException;
import redis.embedded.util.Architecture;
import redis.embedded.util.OS;

public class OSDetector {
    public static OS getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.WINDOWS;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return OS.UNIX;
        }
        if ("Mac OS X".equalsIgnoreCase(osName)) {
            return OS.MAC_OS_X;
        }
        throw new OsDetectionException("Unrecognized OS: " + osName);
    }

    public static Architecture getArchitecture() {
        OS os = OSDetector.getOS();
        switch (os) {
            case WINDOWS: {
                return OSDetector.getWindowsArchitecture();
            }
            case UNIX: {
                return OSDetector.getUnixArchitecture();
            }
            case MAC_OS_X: {
                return OSDetector.getMacOSXArchitecture();
            }
        }
        throw new OsDetectionException("Unrecognized OS: " + (Object)((Object)os));
    }

    private static Architecture getWindowsArchitecture() {
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        if (arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64")) {
            return Architecture.x86_64;
        }
        return Architecture.x86;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Architecture getUnixArchitecture() {
        try {
            Process proc = Runtime.getRuntime().exec("uname -m");
            try (BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String machine;
                switch (machine = input.readLine()) {
                    case "aarch64": {
                        Architecture architecture = Architecture.arm64;
                        return architecture;
                    }
                    case "x86_64": {
                        Architecture architecture = Architecture.x86_64;
                        return architecture;
                    }
                }
                throw new OsDetectionException("unsupported architecture: " + machine);
            }
        }
        catch (Exception e) {
            if (!(e instanceof OsDetectionException)) throw new OsDetectionException(e);
            throw (OsDetectionException)e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Architecture getMacOSXArchitecture() {
        try {
            Process proc = Runtime.getRuntime().exec("uname -m");
            try (BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String machine;
                switch (machine = input.readLine()) {
                    case "arm64": {
                        Architecture architecture = Architecture.arm64;
                        return architecture;
                    }
                    case "x86_64": {
                        Architecture architecture = Architecture.x86_64;
                        return architecture;
                    }
                }
                throw new OsDetectionException("unsupported architecture: " + machine);
            }
        }
        catch (Exception e) {
            if (!(e instanceof OsDetectionException)) throw new OsDetectionException(e);
            throw (OsDetectionException)e;
        }
    }
}

