/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import redis.embedded.Redis;
import redis.embedded.exceptions.EmbeddedRedisException;

abstract class AbstractRedisInstance
implements Redis {
    protected List<String> args = Collections.emptyList();
    private volatile boolean active = false;
    private Process redisProcess;
    private final int port;
    private final int tlsPort;
    private ExecutorService executor;

    protected AbstractRedisInstance(int port, int tlsPort) {
        this.port = port;
        this.tlsPort = tlsPort;
    }

    protected AbstractRedisInstance(int port) {
        this(port, 0);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public synchronized void start() throws EmbeddedRedisException {
        if (this.active) {
            throw new EmbeddedRedisException("This redis server instance is already running...");
        }
        try {
            this.redisProcess = this.createRedisProcessBuilder().start();
            this.installExitHook();
            this.logErrors();
            this.awaitRedisServerReady();
            this.active = true;
        }
        catch (IOException e) {
            throw new EmbeddedRedisException("Failed to start Redis instance", e);
        }
    }

    private void installExitHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop, "RedisInstanceCleaner"));
    }

    private void logErrors() {
        InputStream errorStream = this.redisProcess.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));
        PrintReaderRunnable printReaderTask = new PrintReaderRunnable(reader);
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.submit(printReaderTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitRedisServerReady() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.redisProcess.getInputStream()));
        try {
            String outputLine;
            StringBuilder outputStringBuilder = new StringBuilder();
            do {
                if ((outputLine = reader.readLine()) == null) {
                    throw new EmbeddedRedisException("Redis server failed to become ready. Check logs for details. Redis process log: " + outputStringBuilder.toString());
                }
                outputStringBuilder.append("\n");
                outputStringBuilder.append(outputLine);
            } while (!outputLine.matches(this.redisReadyPattern()));
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader, null);
        }
    }

    protected abstract String redisReadyPattern();

    private ProcessBuilder createRedisProcessBuilder() {
        File executable = new File(this.args.get(0));
        ProcessBuilder pb = new ProcessBuilder(this.args);
        pb.directory(executable.getParentFile());
        return pb;
    }

    @Override
    public synchronized void stop() throws EmbeddedRedisException {
        if (this.active) {
            if (this.executor != null && !this.executor.isShutdown()) {
                this.executor.shutdown();
            }
            this.redisProcess.destroy();
            this.tryWaitFor();
            this.active = false;
        }
    }

    private void tryWaitFor() {
        try {
            this.redisProcess.waitFor();
        }
        catch (InterruptedException e) {
            throw new EmbeddedRedisException("Failed to stop redis instance", e);
        }
    }

    @Override
    public List<Integer> ports() {
        return this.port > 0 ? Collections.singletonList(this.port) : Collections.emptyList();
    }

    @Override
    public List<Integer> tlsPorts() {
        return this.tlsPort > 0 ? Collections.singletonList(this.tlsPort) : Collections.emptyList();
    }

    private static class PrintReaderRunnable
    implements Runnable {
        private final BufferedReader reader;

        private PrintReaderRunnable(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public void run() {
            try {
                this.readLines();
            }
            finally {
                IOUtils.closeQuietly((Closeable)this.reader, null);
            }
        }

        public void readLines() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

