/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import redis.embedded.util.Architecture;
import redis.embedded.util.JarUtil;
import redis.embedded.util.OS;
import redis.embedded.util.OsArchitecture;

public class RedisExecProvider {
    private final Map<OsArchitecture, String> executables = Maps.newHashMap();
    public static final String redisVersion = "7.0.15";

    public static RedisExecProvider defaultProvider() {
        return new RedisExecProvider();
    }

    private RedisExecProvider() {
        this.initExecutables();
    }

    private void initExecutables() {
        this.executables.put(OsArchitecture.UNIX_x86, "redis-server-7.0.15-linux-386");
        this.executables.put(OsArchitecture.UNIX_x86_64, "redis-server-7.0.15-linux-amd64");
        this.executables.put(OsArchitecture.UNIX_arm64, "redis-server-7.0.15-linux-arm64");
        this.executables.put(OsArchitecture.MAC_OS_X_x86_64, "redis-server-7.0.15-darwin-amd64");
        this.executables.put(OsArchitecture.MAC_OS_X_arm64, "redis-server-7.0.15-darwin-arm64");
    }

    public RedisExecProvider override(OS os, String executable) {
        Preconditions.checkNotNull((Object)executable);
        for (Architecture arch : Architecture.values()) {
            this.override(os, arch, executable);
        }
        return this;
    }

    public RedisExecProvider override(OS os, Architecture arch, String executable) {
        Preconditions.checkNotNull((Object)executable);
        this.executables.put(new OsArchitecture(os, arch), executable);
        return this;
    }

    public File get() throws IOException {
        OsArchitecture osArch = OsArchitecture.detect();
        if (!this.executables.containsKey(osArch)) {
            throw new IllegalArgumentException("No Redis executable found for " + osArch);
        }
        String executablePath = this.executables.get(osArch);
        return this.fileExists(executablePath) ? new File(executablePath) : JarUtil.extractExecutableFromJar(executablePath);
    }

    private boolean fileExists(String executablePath) {
        return new File(executablePath).exists();
    }
}

