/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.crypto;

import com.southernstorm.noise.protocol.Destroyable;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;

public class Blake2bMessageDigest
extends MessageDigest
implements Destroyable {
    private long[] h = new long[8];
    private byte[] block = new byte[128];
    private long[] m = new long[16];
    private long[] v = new long[16];
    private long length;
    private int posn;
    static final byte[][] sigma = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}};

    public Blake2bMessageDigest() {
        super("BLAKE2B-512");
        this.engineReset();
    }

    @Override
    protected byte[] engineDigest() {
        byte[] digest = new byte[64];
        try {
            this.engineDigest(digest, 0, 64);
        }
        catch (DigestException e) {
            Arrays.fill(digest, (byte)0);
        }
        return digest;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < 64) {
            throw new DigestException("Invalid digest length for BLAKE2b");
        }
        Arrays.fill(this.block, this.posn, 128, (byte)0);
        this.transform(-1L);
        for (int index = 0; index < 8; ++index) {
            long value = this.h[index];
            buf[offset++] = (byte)value;
            buf[offset++] = (byte)(value >> 8);
            buf[offset++] = (byte)(value >> 16);
            buf[offset++] = (byte)(value >> 24);
            buf[offset++] = (byte)(value >> 32);
            buf[offset++] = (byte)(value >> 40);
            buf[offset++] = (byte)(value >> 48);
            buf[offset++] = (byte)(value >> 56);
        }
        return 32;
    }

    @Override
    protected int engineGetDigestLength() {
        return 64;
    }

    @Override
    protected void engineReset() {
        this.h[0] = 7640891576939301192L;
        this.h[1] = -4942790177534073029L;
        this.h[2] = 4354685564936845355L;
        this.h[3] = -6534734903238641935L;
        this.h[4] = 5840696475078001361L;
        this.h[5] = -7276294671716946913L;
        this.h[6] = 2270897969802886507L;
        this.h[7] = 6620516959819538809L;
        this.length = 0L;
        this.posn = 0;
    }

    @Override
    protected void engineUpdate(byte input) {
        if (this.posn >= 128) {
            this.transform(0L);
            this.posn = 0;
        }
        this.block[this.posn++] = input;
        ++this.length;
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        while (len > 0) {
            int temp;
            if (this.posn >= 128) {
                this.transform(0L);
                this.posn = 0;
            }
            if ((temp = 128 - this.posn) > len) {
                temp = len;
            }
            System.arraycopy(input, offset, this.block, this.posn, temp);
            this.posn += temp;
            this.length += (long)temp;
            offset += temp;
            len -= temp;
        }
    }

    private void transform(long f0) {
        int index = 0;
        int offset = 0;
        while (index < 16) {
            this.m[index] = (long)this.block[offset] & 0xFFL | ((long)this.block[offset + 1] & 0xFFL) << 8 | ((long)this.block[offset + 2] & 0xFFL) << 16 | ((long)this.block[offset + 3] & 0xFFL) << 24 | ((long)this.block[offset + 4] & 0xFFL) << 32 | ((long)this.block[offset + 5] & 0xFFL) << 40 | ((long)this.block[offset + 6] & 0xFFL) << 48 | ((long)this.block[offset + 7] & 0xFFL) << 56;
            ++index;
            offset += 8;
        }
        for (index = 0; index < 8; ++index) {
            this.v[index] = this.h[index];
        }
        this.v[8] = 7640891576956012808L;
        this.v[9] = -4942790177534073029L;
        this.v[10] = 4354685564936845355L;
        this.v[11] = -6534734903238641935L;
        this.v[12] = 0x510E527FADE682D1L ^ this.length;
        this.v[13] = -7276294671716946913L;
        this.v[14] = 0x1F83D9ABFB41BD6BL ^ f0;
        this.v[15] = 6620516959819538809L;
        for (index = 0; index < 12; ++index) {
            this.quarterRound(0, 4, 8, 12, 0, index);
            this.quarterRound(1, 5, 9, 13, 1, index);
            this.quarterRound(2, 6, 10, 14, 2, index);
            this.quarterRound(3, 7, 11, 15, 3, index);
            this.quarterRound(0, 5, 10, 15, 4, index);
            this.quarterRound(1, 6, 11, 12, 5, index);
            this.quarterRound(2, 7, 8, 13, 6, index);
            this.quarterRound(3, 4, 9, 14, 7, index);
        }
        for (index = 0; index < 8; ++index) {
            int n = index;
            this.h[n] = this.h[n] ^ (this.v[index] ^ this.v[index + 8]);
        }
    }

    private static long rightRotate32(long v) {
        return v << 32 | v >>> 32;
    }

    private static long rightRotate24(long v) {
        return v << 40 | v >>> 24;
    }

    private static long rightRotate16(long v) {
        return v << 48 | v >>> 16;
    }

    private static long rightRotate63(long v) {
        return v << 1 | v >>> 63;
    }

    private void quarterRound(int a, int b, int c, int d, int i, int row) {
        int n = a;
        this.v[n] = this.v[n] + (this.v[b] + this.m[sigma[row][2 * i]]);
        this.v[d] = Blake2bMessageDigest.rightRotate32(this.v[d] ^ this.v[a]);
        int n2 = c;
        this.v[n2] = this.v[n2] + this.v[d];
        this.v[b] = Blake2bMessageDigest.rightRotate24(this.v[b] ^ this.v[c]);
        int n3 = a;
        this.v[n3] = this.v[n3] + (this.v[b] + this.m[sigma[row][2 * i + 1]]);
        this.v[d] = Blake2bMessageDigest.rightRotate16(this.v[d] ^ this.v[a]);
        int n4 = c;
        this.v[n4] = this.v[n4] + this.v[d];
        this.v[b] = Blake2bMessageDigest.rightRotate63(this.v[b] ^ this.v[c]);
    }

    @Override
    public void destroy() {
        Arrays.fill(this.h, 0L);
        Arrays.fill(this.block, (byte)0);
        Arrays.fill(this.m, 0L);
        Arrays.fill(this.v, 0L);
    }
}

