/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.crypto;

import com.southernstorm.noise.protocol.Destroyable;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;

public class Blake2sMessageDigest
extends MessageDigest
implements Destroyable {
    private int[] h = new int[8];
    private byte[] block = new byte[64];
    private int[] m = new int[16];
    private int[] v = new int[16];
    private long length;
    private int posn;
    static final byte[][] sigma = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}};

    public Blake2sMessageDigest() {
        super("BLAKE2S-256");
        this.engineReset();
    }

    @Override
    protected byte[] engineDigest() {
        byte[] digest = new byte[32];
        try {
            this.engineDigest(digest, 0, 32);
        }
        catch (DigestException e) {
            Arrays.fill(digest, (byte)0);
        }
        return digest;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < 32) {
            throw new DigestException("Invalid digest length for BLAKE2s");
        }
        Arrays.fill(this.block, this.posn, 64, (byte)0);
        this.transform(-1);
        for (int index = 0; index < 8; ++index) {
            int value = this.h[index];
            buf[offset++] = (byte)value;
            buf[offset++] = (byte)(value >> 8);
            buf[offset++] = (byte)(value >> 16);
            buf[offset++] = (byte)(value >> 24);
        }
        return 32;
    }

    @Override
    protected int engineGetDigestLength() {
        return 32;
    }

    @Override
    protected void engineReset() {
        this.h[0] = 1795745351;
        this.h[1] = -1150833019;
        this.h[2] = 1013904242;
        this.h[3] = -1521486534;
        this.h[4] = 1359893119;
        this.h[5] = -1694144372;
        this.h[6] = 528734635;
        this.h[7] = 1541459225;
        this.length = 0L;
        this.posn = 0;
    }

    @Override
    protected void engineUpdate(byte input) {
        if (this.posn >= 64) {
            this.transform(0);
            this.posn = 0;
        }
        this.block[this.posn++] = input;
        ++this.length;
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        while (len > 0) {
            int temp;
            if (this.posn >= 64) {
                this.transform(0);
                this.posn = 0;
            }
            if ((temp = 64 - this.posn) > len) {
                temp = len;
            }
            System.arraycopy(input, offset, this.block, this.posn, temp);
            this.posn += temp;
            this.length += (long)temp;
            offset += temp;
            len -= temp;
        }
    }

    private void transform(int f0) {
        int index = 0;
        int offset = 0;
        while (index < 16) {
            this.m[index] = this.block[offset] & 0xFF | (this.block[offset + 1] & 0xFF) << 8 | (this.block[offset + 2] & 0xFF) << 16 | (this.block[offset + 3] & 0xFF) << 24;
            ++index;
            offset += 4;
        }
        for (index = 0; index < 8; ++index) {
            this.v[index] = this.h[index];
        }
        this.v[8] = 1779033703;
        this.v[9] = -1150833019;
        this.v[10] = 1013904242;
        this.v[11] = -1521486534;
        this.v[12] = 0x510E527F ^ (int)this.length;
        this.v[13] = 0x9B05688C ^ (int)(this.length >> 32);
        this.v[14] = 0x1F83D9AB ^ f0;
        this.v[15] = 1541459225;
        for (index = 0; index < 10; ++index) {
            this.quarterRound(0, 4, 8, 12, 0, index);
            this.quarterRound(1, 5, 9, 13, 1, index);
            this.quarterRound(2, 6, 10, 14, 2, index);
            this.quarterRound(3, 7, 11, 15, 3, index);
            this.quarterRound(0, 5, 10, 15, 4, index);
            this.quarterRound(1, 6, 11, 12, 5, index);
            this.quarterRound(2, 7, 8, 13, 6, index);
            this.quarterRound(3, 4, 9, 14, 7, index);
        }
        for (index = 0; index < 8; ++index) {
            int n = index;
            this.h[n] = this.h[n] ^ (this.v[index] ^ this.v[index + 8]);
        }
    }

    private static int rightRotate16(int v) {
        return v << 16 | v >>> 16;
    }

    private static int rightRotate12(int v) {
        return v << 20 | v >>> 12;
    }

    private static int rightRotate8(int v) {
        return v << 24 | v >>> 8;
    }

    private static int rightRotate7(int v) {
        return v << 25 | v >>> 7;
    }

    private void quarterRound(int a, int b, int c, int d, int i, int row) {
        int n = a;
        this.v[n] = this.v[n] + (this.v[b] + this.m[sigma[row][2 * i]]);
        this.v[d] = Blake2sMessageDigest.rightRotate16(this.v[d] ^ this.v[a]);
        int n2 = c;
        this.v[n2] = this.v[n2] + this.v[d];
        this.v[b] = Blake2sMessageDigest.rightRotate12(this.v[b] ^ this.v[c]);
        int n3 = a;
        this.v[n3] = this.v[n3] + (this.v[b] + this.m[sigma[row][2 * i + 1]]);
        this.v[d] = Blake2sMessageDigest.rightRotate8(this.v[d] ^ this.v[a]);
        int n4 = c;
        this.v[n4] = this.v[n4] + this.v[d];
        this.v[b] = Blake2sMessageDigest.rightRotate7(this.v[b] ^ this.v[c]);
    }

    @Override
    public void destroy() {
        Arrays.fill(this.h, 0);
        Arrays.fill(this.block, (byte)0);
        Arrays.fill(this.m, 0);
        Arrays.fill(this.v, 0);
    }
}

