/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.crypto;

public final class ChaChaCore {
    private ChaChaCore() {
    }

    public static void hash(int[] output, int[] input) {
        int index;
        for (index = 0; index < 16; ++index) {
            output[index] = input[index];
        }
        for (index = 0; index < 20; index += 2) {
            ChaChaCore.quarterRound(output, 0, 4, 8, 12);
            ChaChaCore.quarterRound(output, 1, 5, 9, 13);
            ChaChaCore.quarterRound(output, 2, 6, 10, 14);
            ChaChaCore.quarterRound(output, 3, 7, 11, 15);
            ChaChaCore.quarterRound(output, 0, 5, 10, 15);
            ChaChaCore.quarterRound(output, 1, 6, 11, 12);
            ChaChaCore.quarterRound(output, 2, 7, 8, 13);
            ChaChaCore.quarterRound(output, 3, 4, 9, 14);
        }
        for (index = 0; index < 16; ++index) {
            int n = index;
            output[n] = output[n] + input[index];
        }
    }

    private static int char4(char c1, char c2, char c3, char c4) {
        return c1 & 0xFF | (c2 & 0xFF) << 8 | (c3 & 0xFF) << 16 | (c4 & 0xFF) << 24;
    }

    private static int fromLittleEndian(byte[] key, int offset) {
        return key[offset] & 0xFF | (key[offset + 1] & 0xFF) << 8 | (key[offset + 2] & 0xFF) << 16 | (key[offset + 3] & 0xFF) << 24;
    }

    public static void initKey128(int[] output, byte[] key, int offset) {
        output[0] = ChaChaCore.char4('e', 'x', 'p', 'a');
        output[1] = ChaChaCore.char4('n', 'd', ' ', '1');
        output[2] = ChaChaCore.char4('6', '-', 'b', 'y');
        output[3] = ChaChaCore.char4('t', 'e', ' ', 'k');
        output[4] = ChaChaCore.fromLittleEndian(key, offset);
        output[5] = ChaChaCore.fromLittleEndian(key, offset + 4);
        output[6] = ChaChaCore.fromLittleEndian(key, offset + 8);
        output[7] = ChaChaCore.fromLittleEndian(key, offset + 12);
        output[8] = output[4];
        output[9] = output[5];
        output[10] = output[6];
        output[11] = output[7];
        output[12] = 0;
        output[13] = 0;
        output[14] = 0;
        output[15] = 0;
    }

    public static void initKey256(int[] output, byte[] key, int offset) {
        output[0] = ChaChaCore.char4('e', 'x', 'p', 'a');
        output[1] = ChaChaCore.char4('n', 'd', ' ', '3');
        output[2] = ChaChaCore.char4('2', '-', 'b', 'y');
        output[3] = ChaChaCore.char4('t', 'e', ' ', 'k');
        output[4] = ChaChaCore.fromLittleEndian(key, offset);
        output[5] = ChaChaCore.fromLittleEndian(key, offset + 4);
        output[6] = ChaChaCore.fromLittleEndian(key, offset + 8);
        output[7] = ChaChaCore.fromLittleEndian(key, offset + 12);
        output[8] = ChaChaCore.fromLittleEndian(key, offset + 16);
        output[9] = ChaChaCore.fromLittleEndian(key, offset + 20);
        output[10] = ChaChaCore.fromLittleEndian(key, offset + 24);
        output[11] = ChaChaCore.fromLittleEndian(key, offset + 28);
        output[12] = 0;
        output[13] = 0;
        output[14] = 0;
        output[15] = 0;
    }

    public static void initIV(int[] output, long iv) {
        output[12] = 0;
        output[13] = 0;
        output[14] = (int)iv;
        output[15] = (int)(iv >> 32);
    }

    public static void initIV(int[] output, long iv, long counter) {
        output[12] = (int)counter;
        output[13] = (int)(counter >> 32);
        output[14] = (int)iv;
        output[15] = (int)(iv >> 32);
    }

    private static int leftRotate16(int v) {
        return v << 16 | v >>> 16;
    }

    private static int leftRotate12(int v) {
        return v << 12 | v >>> 20;
    }

    private static int leftRotate8(int v) {
        return v << 8 | v >>> 24;
    }

    private static int leftRotate7(int v) {
        return v << 7 | v >>> 25;
    }

    private static void quarterRound(int[] v, int a, int b, int c, int d) {
        int n = a;
        v[n] = v[n] + v[b];
        v[d] = ChaChaCore.leftRotate16(v[d] ^ v[a]);
        int n2 = c;
        v[n2] = v[n2] + v[d];
        v[b] = ChaChaCore.leftRotate12(v[b] ^ v[c]);
        int n3 = a;
        v[n3] = v[n3] + v[b];
        v[d] = ChaChaCore.leftRotate8(v[d] ^ v[a]);
        int n4 = c;
        v[n4] = v[n4] + v[d];
        v[b] = ChaChaCore.leftRotate7(v[b] ^ v[c]);
    }
}

