/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.crypto;

import java.util.Arrays;

public final class Curve448 {
    private int[] x_1 = new int[16];
    private int[] x_2 = new int[16];
    private int[] x_3 = new int[16];
    private int[] z_2 = new int[16];
    private int[] z_3 = new int[16];
    private int[] A = new int[16];
    private int[] B = new int[16];
    private int[] C = new int[16];
    private int[] D = new int[16];
    private int[] E = new int[16];
    private int[] AA = new int[16];
    private int[] BB = new int[16];
    private int[] DA = new int[16];
    private int[] CB = new int[16];
    private int[] aa = new int[8];
    private int[] bb = new int[8];

    private Curve448() {
    }

    private void destroy() {
        Arrays.fill(this.x_1, 0);
        Arrays.fill(this.x_2, 0);
        Arrays.fill(this.x_3, 0);
        Arrays.fill(this.z_2, 0);
        Arrays.fill(this.z_3, 0);
        Arrays.fill(this.A, 0);
        Arrays.fill(this.B, 0);
        Arrays.fill(this.C, 0);
        Arrays.fill(this.D, 0);
        Arrays.fill(this.E, 0);
        Arrays.fill(this.AA, 0);
        Arrays.fill(this.BB, 0);
        Arrays.fill(this.DA, 0);
        Arrays.fill(this.CB, 0);
        Arrays.fill(this.aa, 0);
        Arrays.fill(this.bb, 0);
    }

    private static long widemul_32(int a, int b) {
        return (long)a * (long)b;
    }

    private void mul(int[] c, int[] a, int[] b) {
        int i;
        long accum0 = 0L;
        long accum1 = 0L;
        long accum2 = 0L;
        int mask = 0xFFFFFFF;
        for (i = 0; i < 8; ++i) {
            this.aa[i] = a[i] + a[i + 8];
            this.bb[i] = b[i] + b[i + 8];
        }
        for (int j = 0; j < 8; ++j) {
            accum2 = 0L;
            for (i = 0; i <= j; ++i) {
                accum2 += Curve448.widemul_32(a[j - i], b[i]);
                accum1 += Curve448.widemul_32(this.aa[j - i], this.bb[i]);
                accum0 += Curve448.widemul_32(a[8 + j - i], b[8 + i]);
            }
            accum1 -= accum2;
            accum0 += accum2;
            accum2 = 0L;
            while (i < 8) {
                accum0 -= Curve448.widemul_32(a[8 + j - i], b[i]);
                accum2 += Curve448.widemul_32(this.aa[8 + j - i], this.bb[i]);
                accum1 += Curve448.widemul_32(a[16 + j - i], b[8 + i]);
                ++i;
            }
            c[j] = (int)(accum0 += accum2) & mask;
            c[j + 8] = (int)(accum1 += accum2) & mask;
            accum0 >>>= 28;
            accum1 >>>= 28;
        }
        accum0 += accum1;
        c[8] = (int)(accum0 += (long)c[8]) & mask;
        c[0] = (int)(accum1 += (long)c[0]) & mask;
        c[9] = c[9] + (int)(accum0 >>>= 28);
        c[1] = c[1] + (int)(accum1 >>>= 28);
    }

    private static void mulw(int[] c, int[] a, long b) {
        int bhi = (int)(b >> 28);
        int blo = (int)b & 0xFFFFFFF;
        int mask = 0xFFFFFFF;
        long accum0 = Curve448.widemul_32(blo, a[0]);
        long accum8 = Curve448.widemul_32(blo, a[8]);
        c[0] = (int)(accum0 += Curve448.widemul_32(bhi, a[15])) & mask;
        accum0 >>>= 28;
        c[8] = (int)(accum8 += Curve448.widemul_32(bhi, a[15] + a[7])) & mask;
        accum8 >>>= 28;
        for (int i = 1; i < 8; ++i) {
            accum0 += Curve448.widemul_32(blo, a[i]);
            accum8 += Curve448.widemul_32(blo, a[i + 8]);
            c[i] = (int)(accum0 += Curve448.widemul_32(bhi, a[i - 1])) & mask;
            accum0 >>>= 28;
            c[i + 8] = (int)(accum8 += Curve448.widemul_32(bhi, a[i + 7])) & mask;
            accum8 >>>= 28;
        }
        c[8] = (int)(accum0 += accum8 + (long)c[8]) & mask;
        c[9] = (int)((long)c[9] + (accum0 >>> 28));
        c[0] = (int)(accum8 += (long)c[0]) & mask;
        c[1] = (int)((long)c[1] + (accum8 >>> 28));
    }

    private static void weak_reduce(int[] a) {
        int mask = 0xFFFFFFF;
        int tmp = a[15] >>> 28;
        a[8] = a[8] + tmp;
        for (int i = 15; i > 0; --i) {
            a[i] = (a[i] & mask) + (a[i - 1] >>> 28);
        }
        a[0] = (a[0] & mask) + tmp;
    }

    private static void strong_reduce(int[] a) {
        int i;
        int mask = 0xFFFFFFF;
        a[8] = a[8] + (a[15] >>> 28);
        a[0] = a[0] + (a[15] >>> 28);
        a[15] = a[15] & mask;
        long scarry = 0L;
        for (i = 0; i < 16; ++i) {
            scarry = scarry + ((long)a[i] & 0xFFFFFFFFL) - (long)(i == 8 ? mask - 1 : mask);
            a[i] = (int)(scarry & (long)mask);
            scarry >>= 28;
        }
        int scarry_mask = (int)(scarry & (long)mask);
        long carry = 0L;
        for (i = 0; i < 16; ++i) {
            carry = carry + ((long)a[i] & 0xFFFFFFFFL) + (long)(i == 8 ? scarry_mask & 0xFFFFFFFE : scarry_mask);
            a[i] = (int)(carry & (long)mask);
            carry >>>= 28;
        }
    }

    private static void add(int[] out, int[] a, int[] b) {
        for (int i = 0; i < 16; ++i) {
            out[i] = a[i] + b[i];
        }
        Curve448.weak_reduce(out);
    }

    private static void sub(int[] out, int[] a, int[] b) {
        int i;
        for (i = 0; i < 16; ++i) {
            out[i] = a[i] - b[i];
        }
        int co1 = 0x1FFFFFFE;
        int co2 = co1 - 2;
        for (i = 0; i < 16; ++i) {
            if (i != 8) {
                int n = i;
                out[n] = out[n] + co1;
                continue;
            }
            int n = i;
            out[n] = out[n] + co2;
        }
        Curve448.weak_reduce(out);
    }

    private static void serialize(byte[] serial, int offset, int[] x) {
        for (int i = 0; i < 8; ++i) {
            long limb = (long)x[2 * i] + ((long)x[2 * i + 1] << 28);
            for (int j = 0; j < 7; ++j) {
                serial[offset + 7 * i + j] = (byte)limb;
                limb >>= 8;
            }
        }
    }

    private static int is_zero(int x) {
        long xx = (long)x & 0xFFFFFFFFL;
        return (int)(--xx >> 32);
    }

    private static int deserialize(int[] x, byte[] serial, int offset) {
        int i;
        for (i = 0; i < 8; ++i) {
            long out = 0L;
            for (int j = 0; j < 7; ++j) {
                out |= ((long)serial[offset + 7 * i + j] & 0xFFL) << 8 * j;
            }
            x[2 * i] = (int)out & 0xFFFFFFF;
            x[2 * i + 1] = (int)(out >>> 28);
        }
        int ge = -1;
        int mask = 0xFFFFFFF;
        for (i = 0; i < 8; ++i) {
            ge &= x[i];
        }
        ge = ge & x[8] + 1 | Curve448.is_zero(x[8] ^ mask);
        for (i = 9; i < 16; ++i) {
            ge &= x[i];
        }
        return ~Curve448.is_zero(ge ^ mask);
    }

    private void square(int[] result, int[] x) {
        this.mul(result, x, x);
    }

    private static void cswap(int select, int[] x, int[] y) {
        select = -select;
        int index = 0;
        while (index < 16) {
            int dummy = select & (x[index] ^ y[index]);
            int n = index;
            x[n] = x[n] ^ dummy;
            int n2 = index++;
            y[n2] = y[n2] ^ dummy;
        }
    }

    private void recip(int[] result, int[] z_2) {
        int posn;
        this.square(this.B, z_2);
        this.mul(this.A, this.B, z_2);
        this.square(this.B, this.A);
        this.mul(this.A, this.B, z_2);
        this.square(this.B, this.A);
        this.mul(this.A, this.B, z_2);
        this.square(this.B, this.A);
        this.mul(this.C, this.B, z_2);
        this.square(this.B, this.C);
        this.mul(this.C, this.B, z_2);
        this.square(this.B, this.C);
        this.mul(this.A, this.B, z_2);
        this.square(this.B, this.A);
        this.mul(this.A, this.B, z_2);
        this.square(this.E, this.A);
        this.square(this.B, this.E);
        for (posn = 1; posn < 4; ++posn) {
            this.square(this.E, this.B);
            this.square(this.B, this.E);
        }
        this.mul(this.E, this.B, this.A);
        this.square(this.AA, this.E);
        this.square(this.B, this.AA);
        for (posn = 1; posn < 8; ++posn) {
            this.square(this.AA, this.B);
            this.square(this.B, this.AA);
        }
        this.mul(this.AA, this.B, this.E);
        this.square(this.BB, this.AA);
        this.square(this.B, this.BB);
        for (posn = 1; posn < 16; ++posn) {
            this.square(this.BB, this.B);
            this.square(this.B, this.BB);
        }
        this.mul(this.BB, this.B, this.AA);
        this.square(this.DA, this.BB);
        this.square(this.B, this.DA);
        for (posn = 1; posn < 32; ++posn) {
            this.square(this.DA, this.B);
            this.square(this.B, this.DA);
        }
        this.mul(this.DA, this.B, this.BB);
        this.square(this.CB, this.DA);
        this.square(this.B, this.CB);
        for (posn = 1; posn < 32; ++posn) {
            this.square(this.CB, this.B);
            this.square(this.B, this.CB);
        }
        this.mul(this.CB, this.B, this.BB);
        this.square(this.DA, this.CB);
        this.square(this.B, this.DA);
        for (posn = 1; posn < 8; ++posn) {
            this.square(this.DA, this.B);
            this.square(this.B, this.DA);
        }
        this.mul(this.DA, this.B, this.E);
        this.square(this.CB, this.DA);
        this.square(this.B, this.CB);
        for (posn = 1; posn < 4; ++posn) {
            this.square(this.CB, this.B);
            this.square(this.B, this.CB);
        }
        this.mul(this.CB, this.B, this.A);
        this.square(this.DA, this.CB);
        this.square(this.B, this.DA);
        for (posn = 1; posn < 3; ++posn) {
            this.square(this.DA, this.B);
            this.square(this.B, this.DA);
        }
        this.mul(this.DA, this.B, this.C);
        this.square(this.CB, this.DA);
        this.mul(this.B, this.CB, z_2);
        this.square(this.CB, this.B);
        this.square(this.BB, this.CB);
        this.square(this.B, this.BB);
        for (posn = 1; posn < 111; ++posn) {
            this.square(this.BB, this.B);
            this.square(this.B, this.BB);
        }
        this.mul(this.BB, this.B, this.DA);
        this.square(this.B, this.BB);
        this.square(this.BB, this.B);
        this.mul(result, this.BB, z_2);
    }

    private void evalCurve(byte[] s) {
        int sposn = 55;
        int sbit = 7;
        int svalue = s[sposn] | 0x80;
        int swap = 0;
        while (true) {
            int select = svalue >> sbit & 1;
            Curve448.cswap(swap ^= select, this.x_2, this.x_3);
            Curve448.cswap(swap, this.z_2, this.z_3);
            swap = select;
            Curve448.add(this.A, this.x_2, this.z_2);
            this.square(this.AA, this.A);
            Curve448.sub(this.B, this.x_2, this.z_2);
            this.square(this.BB, this.B);
            Curve448.sub(this.E, this.AA, this.BB);
            Curve448.add(this.C, this.x_3, this.z_3);
            Curve448.sub(this.D, this.x_3, this.z_3);
            this.mul(this.DA, this.D, this.A);
            this.mul(this.CB, this.C, this.B);
            Curve448.add(this.z_2, this.DA, this.CB);
            this.square(this.x_3, this.z_2);
            Curve448.sub(this.z_2, this.DA, this.CB);
            this.square(this.x_2, this.z_2);
            this.mul(this.z_3, this.x_1, this.x_2);
            this.mul(this.x_2, this.AA, this.BB);
            Curve448.mulw(this.z_2, this.E, 39081L);
            Curve448.add(this.A, this.AA, this.z_2);
            this.mul(this.z_2, this.E, this.A);
            if (sbit > 0) {
                --sbit;
                continue;
            }
            if (sposn == 0) break;
            if (sposn == 1) {
                svalue = s[--sposn] & 0xFC;
                sbit = 7;
                continue;
            }
            svalue = s[--sposn];
            sbit = 7;
        }
        Curve448.cswap(swap, this.x_2, this.x_3);
        Curve448.cswap(swap, this.z_2, this.z_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean eval(byte[] result, int offset, byte[] privateKey, byte[] publicKey) {
        Curve448 state = new Curve448();
        int success = -1;
        try {
            Arrays.fill(state.x_1, 0);
            if (publicKey != null) {
                success = Curve448.deserialize(state.x_1, publicKey, 0);
            } else {
                state.x_1[0] = 5;
            }
            Arrays.fill(state.x_2, 0);
            state.x_2[0] = 1;
            Arrays.fill(state.z_2, 0);
            System.arraycopy(state.x_1, 0, state.x_3, 0, state.x_1.length);
            Arrays.fill(state.z_3, 0);
            state.z_3[0] = 1;
            state.evalCurve(privateKey);
            state.recip(state.z_3, state.z_2);
            state.mul(state.x_1, state.x_2, state.z_3);
            Curve448.strong_reduce(state.x_1);
            Curve448.serialize(result, offset, state.x_1);
        }
        finally {
            state.destroy();
        }
        return (success & 1) != 0;
    }
}

