/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.crypto;

import com.southernstorm.noise.protocol.Destroyable;
import java.util.Arrays;

public final class GHASH
implements Destroyable {
    private long[] H = new long[2];
    private byte[] Y = new byte[16];
    int posn = 0;

    public void reset(byte[] key, int offset) {
        this.H[0] = GHASH.readBigEndian(key, offset);
        this.H[1] = GHASH.readBigEndian(key, offset + 8);
        Arrays.fill(this.Y, (byte)0);
        this.posn = 0;
    }

    public void reset() {
        Arrays.fill(this.Y, (byte)0);
        this.posn = 0;
    }

    public void update(byte[] data, int offset, int length) {
        while (length > 0) {
            int size = 16 - this.posn;
            if (size > length) {
                size = length;
            }
            for (int index = 0; index < size; ++index) {
                int n = this.posn + index;
                this.Y[n] = (byte)(this.Y[n] ^ data[offset + index]);
            }
            this.posn += size;
            length -= size;
            offset += size;
            if (this.posn != 16) continue;
            GHASH.GF128_mul(this.Y, this.H);
            this.posn = 0;
        }
    }

    public void finish(byte[] tag, int offset, int length) {
        this.pad();
        System.arraycopy(this.Y, 0, tag, offset, length);
    }

    public void pad() {
        if (this.posn != 0) {
            GHASH.GF128_mul(this.Y, this.H);
            this.posn = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pad(long adLen, long dataLen) {
        byte[] temp = new byte[16];
        try {
            this.pad();
            GHASH.writeBigEndian(temp, 0, adLen * 8L);
            GHASH.writeBigEndian(temp, 8, dataLen * 8L);
            this.update(temp, 0, 16);
        }
        finally {
            Arrays.fill(temp, (byte)0);
        }
    }

    @Override
    public void destroy() {
        Arrays.fill(this.H, 0L);
        Arrays.fill(this.Y, (byte)0);
    }

    private static long readBigEndian(byte[] buf, int offset) {
        return ((long)buf[offset] & 0xFFL) << 56 | ((long)buf[offset + 1] & 0xFFL) << 48 | ((long)buf[offset + 2] & 0xFFL) << 40 | ((long)buf[offset + 3] & 0xFFL) << 32 | ((long)buf[offset + 4] & 0xFFL) << 24 | ((long)buf[offset + 5] & 0xFFL) << 16 | ((long)buf[offset + 6] & 0xFFL) << 8 | (long)buf[offset + 7] & 0xFFL;
    }

    private static void writeBigEndian(byte[] buf, int offset, long value) {
        buf[offset] = (byte)(value >> 56);
        buf[offset + 1] = (byte)(value >> 48);
        buf[offset + 2] = (byte)(value >> 40);
        buf[offset + 3] = (byte)(value >> 32);
        buf[offset + 4] = (byte)(value >> 24);
        buf[offset + 5] = (byte)(value >> 16);
        buf[offset + 6] = (byte)(value >> 8);
        buf[offset + 7] = (byte)value;
    }

    private static void GF128_mul(byte[] Y, long[] H) {
        long Z0 = 0L;
        long Z1 = 0L;
        long V0 = H[0];
        long V1 = H[1];
        for (int posn = 0; posn < 16; ++posn) {
            int value = Y[posn] & 0xFF;
            for (int bit = 7; bit >= 0; --bit) {
                long mask = -((long)(value >> bit & 1));
                Z0 ^= V0 & mask;
                Z1 ^= V1 & mask;
                mask = (V1 & 1L ^ 0xFFFFFFFFFFFFFFFFL) + 1L & 0xE100000000000000L;
                V1 = V1 >>> 1 | V0 << 63;
                V0 = V0 >>> 1 ^ mask;
            }
        }
        GHASH.writeBigEndian(Y, 0, Z0);
        GHASH.writeBigEndian(Y, 8, Z1);
    }
}

