/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.crypto;

import com.southernstorm.noise.protocol.Destroyable;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;

public class SHA256MessageDigest
extends MessageDigest
implements Destroyable {
    private int[] h = new int[8];
    private byte[] block = new byte[64];
    private int[] w = new int[64];
    private long length;
    private int posn;
    private static final int[] k = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    public SHA256MessageDigest() {
        super("SHA-256");
        this.engineReset();
    }

    @Override
    public void destroy() {
        Arrays.fill(this.h, 0);
        Arrays.fill(this.block, (byte)0);
        Arrays.fill(this.w, 0);
    }

    private static void writeBE32(byte[] buf, int offset, int value) {
        buf[offset] = (byte)(value >> 24);
        buf[offset + 1] = (byte)(value >> 16);
        buf[offset + 2] = (byte)(value >> 8);
        buf[offset + 3] = (byte)value;
    }

    @Override
    protected byte[] engineDigest() {
        byte[] digest = new byte[32];
        try {
            this.engineDigest(digest, 0, 32);
        }
        catch (DigestException e) {
            Arrays.fill(digest, (byte)0);
        }
        return digest;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < 32) {
            throw new DigestException("Invalid digest length for SHA256");
        }
        if (this.posn <= 55) {
            this.block[this.posn] = -128;
            Arrays.fill(this.block, this.posn + 1, 56, (byte)0);
        } else {
            this.block[this.posn] = -128;
            Arrays.fill(this.block, this.posn + 1, 64, (byte)0);
            this.transform(this.block, 0);
            Arrays.fill(this.block, 0, 56, (byte)0);
        }
        SHA256MessageDigest.writeBE32(this.block, 56, (int)(this.length >> 32));
        SHA256MessageDigest.writeBE32(this.block, 60, (int)this.length);
        this.transform(this.block, 0);
        this.posn = 0;
        for (int index = 0; index < 8; ++index) {
            SHA256MessageDigest.writeBE32(buf, offset + index * 4, this.h[index]);
        }
        return 32;
    }

    @Override
    protected int engineGetDigestLength() {
        return 32;
    }

    @Override
    protected void engineReset() {
        this.h[0] = 1779033703;
        this.h[1] = -1150833019;
        this.h[2] = 1013904242;
        this.h[3] = -1521486534;
        this.h[4] = 1359893119;
        this.h[5] = -1694144372;
        this.h[6] = 528734635;
        this.h[7] = 1541459225;
        this.length = 0L;
        this.posn = 0;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.block[this.posn++] = input;
        this.length += 8L;
        if (this.posn >= 64) {
            this.transform(this.block, 0);
            this.posn = 0;
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        while (len > 0) {
            if (this.posn == 0 && len >= 64) {
                this.transform(input, offset);
                offset += 64;
                len -= 64;
                this.length += 512L;
                continue;
            }
            int temp = 64 - this.posn;
            if (temp > len) {
                temp = len;
            }
            System.arraycopy(input, offset, this.block, this.posn, temp);
            this.posn += temp;
            this.length += (long)(temp * 8);
            if (this.posn >= 64) {
                this.transform(this.block, 0);
                this.posn = 0;
            }
            offset += temp;
            len -= temp;
        }
    }

    private static int rightRotate(int value, int n) {
        return value >>> n | value << 32 - n;
    }

    private void transform(byte[] m, int offset) {
        int index;
        int a = this.h[0];
        int b = this.h[1];
        int c = this.h[2];
        int d = this.h[3];
        int e = this.h[4];
        int f = this.h[5];
        int g = this.h[6];
        int h = this.h[7];
        for (index = 0; index < 16; ++index) {
            this.w[index] = (m[offset] & 0xFF) << 24 | (m[offset + 1] & 0xFF) << 16 | (m[offset + 2] & 0xFF) << 8 | m[offset + 3] & 0xFF;
            offset += 4;
        }
        for (index = 16; index < 64; ++index) {
            this.w[index] = this.w[index - 16] + this.w[index - 7] + (SHA256MessageDigest.rightRotate(this.w[index - 15], 7) ^ SHA256MessageDigest.rightRotate(this.w[index - 15], 18) ^ this.w[index - 15] >>> 3) + (SHA256MessageDigest.rightRotate(this.w[index - 2], 17) ^ SHA256MessageDigest.rightRotate(this.w[index - 2], 19) ^ this.w[index - 2] >>> 10);
        }
        for (index = 0; index < 64; ++index) {
            int temp1 = h + k[index] + this.w[index] + (SHA256MessageDigest.rightRotate(e, 6) ^ SHA256MessageDigest.rightRotate(e, 11) ^ SHA256MessageDigest.rightRotate(e, 25)) + (e & f ^ ~e & g);
            int temp2 = (SHA256MessageDigest.rightRotate(a, 2) ^ SHA256MessageDigest.rightRotate(a, 13) ^ SHA256MessageDigest.rightRotate(a, 22)) + (a & b ^ a & c ^ b & c);
            h = g;
            g = f;
            f = e;
            e = d + temp1;
            d = c;
            c = b;
            b = a;
            a = temp1 + temp2;
        }
        this.h[0] = this.h[0] + a;
        this.h[1] = this.h[1] + b;
        this.h[2] = this.h[2] + c;
        this.h[3] = this.h[3] + d;
        this.h[4] = this.h[4] + e;
        this.h[5] = this.h[5] + f;
        this.h[6] = this.h[6] + g;
        this.h[7] = this.h[7] + h;
    }
}

