/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.crypto;

import com.southernstorm.noise.protocol.Destroyable;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;

public class SHA512MessageDigest
extends MessageDigest
implements Destroyable {
    private long[] h = new long[8];
    private byte[] block = new byte[128];
    private long[] w = new long[80];
    private long length;
    private int posn;
    private static final long[] k = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};

    public SHA512MessageDigest() {
        super("SHA-512");
        this.engineReset();
    }

    @Override
    public void destroy() {
        Arrays.fill(this.h, 0L);
        Arrays.fill(this.block, (byte)0);
        Arrays.fill(this.w, 0L);
    }

    private static void writeBE64(byte[] buf, int offset, long value) {
        buf[offset] = (byte)(value >> 56);
        buf[offset + 1] = (byte)(value >> 48);
        buf[offset + 2] = (byte)(value >> 40);
        buf[offset + 3] = (byte)(value >> 32);
        buf[offset + 4] = (byte)(value >> 24);
        buf[offset + 5] = (byte)(value >> 16);
        buf[offset + 6] = (byte)(value >> 8);
        buf[offset + 7] = (byte)value;
    }

    @Override
    protected byte[] engineDigest() {
        byte[] digest = new byte[64];
        try {
            this.engineDigest(digest, 0, 64);
        }
        catch (DigestException e) {
            Arrays.fill(digest, (byte)0);
        }
        return digest;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < 64) {
            throw new DigestException("Invalid digest length for SHA512");
        }
        if (this.posn <= 111) {
            this.block[this.posn] = -128;
            Arrays.fill(this.block, this.posn + 1, 120, (byte)0);
        } else {
            this.block[this.posn] = -128;
            Arrays.fill(this.block, this.posn + 1, 128, (byte)0);
            this.transform(this.block, 0);
            Arrays.fill(this.block, 0, 120, (byte)0);
        }
        SHA512MessageDigest.writeBE64(this.block, 120, this.length);
        this.transform(this.block, 0);
        this.posn = 0;
        for (int index = 0; index < 8; ++index) {
            SHA512MessageDigest.writeBE64(buf, offset + index * 8, this.h[index]);
        }
        return 64;
    }

    @Override
    protected int engineGetDigestLength() {
        return 64;
    }

    @Override
    protected void engineReset() {
        this.h[0] = 7640891576956012808L;
        this.h[1] = -4942790177534073029L;
        this.h[2] = 4354685564936845355L;
        this.h[3] = -6534734903238641935L;
        this.h[4] = 5840696475078001361L;
        this.h[5] = -7276294671716946913L;
        this.h[6] = 2270897969802886507L;
        this.h[7] = 6620516959819538809L;
        this.length = 0L;
        this.posn = 0;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.block[this.posn++] = input;
        this.length += 8L;
        if (this.posn >= 128) {
            this.transform(this.block, 0);
            this.posn = 0;
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        while (len > 0) {
            if (this.posn == 0 && len >= 128) {
                this.transform(input, offset);
                offset += 128;
                len -= 128;
                this.length += 1024L;
                continue;
            }
            int temp = 128 - this.posn;
            if (temp > len) {
                temp = len;
            }
            System.arraycopy(input, offset, this.block, this.posn, temp);
            this.posn += temp;
            this.length += (long)(temp * 8);
            if (this.posn >= 128) {
                this.transform(this.block, 0);
                this.posn = 0;
            }
            offset += temp;
            len -= temp;
        }
    }

    private static long rightRotate(long value, int n) {
        return value >>> n | value << 64 - n;
    }

    private void transform(byte[] m, int offset) {
        int index;
        long a = this.h[0];
        long b = this.h[1];
        long c = this.h[2];
        long d = this.h[3];
        long e = this.h[4];
        long f = this.h[5];
        long g = this.h[6];
        long h = this.h[7];
        for (index = 0; index < 16; ++index) {
            this.w[index] = ((long)m[offset] & 0xFFL) << 56 | ((long)m[offset + 1] & 0xFFL) << 48 | ((long)m[offset + 2] & 0xFFL) << 40 | ((long)m[offset + 3] & 0xFFL) << 32 | ((long)m[offset + 4] & 0xFFL) << 24 | ((long)m[offset + 5] & 0xFFL) << 16 | ((long)m[offset + 6] & 0xFFL) << 8 | (long)m[offset + 7] & 0xFFL;
            offset += 8;
        }
        for (index = 16; index < 80; ++index) {
            this.w[index] = this.w[index - 16] + this.w[index - 7] + (SHA512MessageDigest.rightRotate(this.w[index - 15], 1) ^ SHA512MessageDigest.rightRotate(this.w[index - 15], 8) ^ this.w[index - 15] >>> 7) + (SHA512MessageDigest.rightRotate(this.w[index - 2], 19) ^ SHA512MessageDigest.rightRotate(this.w[index - 2], 61) ^ this.w[index - 2] >>> 6);
        }
        for (index = 0; index < 80; ++index) {
            long temp1 = h + k[index] + this.w[index] + (SHA512MessageDigest.rightRotate(e, 14) ^ SHA512MessageDigest.rightRotate(e, 18) ^ SHA512MessageDigest.rightRotate(e, 41)) + (e & f ^ (e ^ 0xFFFFFFFFFFFFFFFFL) & g);
            long temp2 = (SHA512MessageDigest.rightRotate(a, 28) ^ SHA512MessageDigest.rightRotate(a, 34) ^ SHA512MessageDigest.rightRotate(a, 39)) + (a & b ^ a & c ^ b & c);
            h = g;
            g = f;
            f = e;
            e = d + temp1;
            d = c;
            c = b;
            b = a;
            a = temp1 + temp2;
        }
        this.h[0] = this.h[0] + a;
        this.h[1] = this.h[1] + b;
        this.h[2] = this.h[2] + c;
        this.h[3] = this.h[3] + d;
        this.h[4] = this.h[4] + e;
        this.h[5] = this.h[5] + f;
        this.h[6] = this.h[6] + g;
        this.h[7] = this.h[7] + h;
    }
}

