/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.crypto.GHASH;
import com.southernstorm.noise.crypto.RijndaelAES;
import com.southernstorm.noise.protocol.CipherState;
import com.southernstorm.noise.protocol.Noise;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.ShortBufferException;

class AESGCMFallbackCipherState
implements CipherState {
    private RijndaelAES aes = new RijndaelAES();
    private long n = 0L;
    private byte[] iv = new byte[16];
    private byte[] enciv = new byte[16];
    private byte[] hashKey = new byte[16];
    private GHASH ghash = new GHASH();
    private boolean haskey = false;

    @Override
    public void destroy() {
        this.aes.destroy();
        this.ghash.destroy();
        Noise.destroy(this.hashKey);
        Noise.destroy(this.iv);
        Noise.destroy(this.enciv);
    }

    @Override
    public String getCipherName() {
        return "AESGCM";
    }

    @Override
    public int getKeyLength() {
        return 32;
    }

    @Override
    public int getMACLength() {
        return this.haskey ? 16 : 0;
    }

    @Override
    public void initializeKey(byte[] key, int offset) {
        this.aes.setupEnc(key, offset, 256);
        this.haskey = true;
        Arrays.fill(this.hashKey, (byte)0);
        this.aes.encrypt(this.hashKey, 0, this.hashKey, 0);
        this.ghash.reset(this.hashKey, 0);
        this.n = 0L;
    }

    @Override
    public boolean hasKey() {
        return this.haskey;
    }

    private void setup(byte[] ad) {
        if (this.n == -1L) {
            throw new IllegalStateException("Nonce has wrapped around");
        }
        this.iv[0] = 0;
        this.iv[1] = 0;
        this.iv[2] = 0;
        this.iv[3] = 0;
        this.iv[4] = (byte)(this.n >> 56);
        this.iv[5] = (byte)(this.n >> 48);
        this.iv[6] = (byte)(this.n >> 40);
        this.iv[7] = (byte)(this.n >> 32);
        this.iv[8] = (byte)(this.n >> 24);
        this.iv[9] = (byte)(this.n >> 16);
        this.iv[10] = (byte)(this.n >> 8);
        this.iv[11] = (byte)this.n;
        this.iv[12] = 0;
        this.iv[13] = 0;
        this.iv[14] = 0;
        this.iv[15] = 1;
        Arrays.fill(this.hashKey, (byte)0);
        this.aes.encrypt(this.iv, 0, this.hashKey, 0);
        this.ghash.reset();
        if (ad != null) {
            this.ghash.update(ad, 0, ad.length);
            this.ghash.pad();
        }
    }

    private void encryptCTR(byte[] plaintext, int plaintextOffset, byte[] ciphertext, int ciphertextOffset, int length) {
        while (length > 0) {
            this.iv[15] = (byte)(this.iv[15] + 1);
            if (this.iv[15] == 0 && (this.iv[14] = (byte)(this.iv[14] + 1)) == 0 && (this.iv[13] = (byte)(this.iv[13] + 1)) == 0) {
                this.iv[12] = (byte)(this.iv[12] + 1);
            }
            this.aes.encrypt(this.iv, 0, this.enciv, 0);
            int temp = length;
            if (temp > 16) {
                temp = 16;
            }
            for (int index = 0; index < temp; ++index) {
                ciphertext[ciphertextOffset + index] = (byte)(plaintext[plaintextOffset + index] ^ this.enciv[index]);
            }
            plaintextOffset += temp;
            ciphertextOffset += temp;
            length -= temp;
        }
    }

    @Override
    public int encryptWithAd(byte[] ad, byte[] plaintext, int plaintextOffset, byte[] ciphertext, int ciphertextOffset, int length) throws ShortBufferException {
        if (ciphertextOffset < 0 || ciphertextOffset > ciphertext.length) {
            throw new IllegalArgumentException();
        }
        if (length < 0 || plaintextOffset < 0 || plaintextOffset > plaintext.length || length > plaintext.length || plaintext.length - plaintextOffset < length) {
            throw new IllegalArgumentException();
        }
        int space = ciphertext.length - ciphertextOffset;
        if (!this.haskey) {
            if (length > space) {
                throw new ShortBufferException();
            }
            if (plaintext != ciphertext || plaintextOffset != ciphertextOffset) {
                System.arraycopy(plaintext, plaintextOffset, ciphertext, ciphertextOffset, length);
            }
            return length;
        }
        if (space < 16 || length > space - 16) {
            throw new ShortBufferException();
        }
        this.setup(ad);
        this.encryptCTR(plaintext, plaintextOffset, ciphertext, ciphertextOffset, length);
        this.ghash.update(ciphertext, ciphertextOffset, length);
        this.ghash.pad(ad != null ? (long)ad.length : 0L, length);
        this.ghash.finish(ciphertext, ciphertextOffset + length, 16);
        for (int index = 0; index < 16; ++index) {
            int n = ciphertextOffset + length + index;
            ciphertext[n] = (byte)(ciphertext[n] ^ this.hashKey[index]);
        }
        ++this.n;
        return length + 16;
    }

    @Override
    public int decryptWithAd(byte[] ad, byte[] ciphertext, int ciphertextOffset, byte[] plaintext, int plaintextOffset, int length) throws ShortBufferException, BadPaddingException {
        int dataLen;
        if (ciphertextOffset < 0 || ciphertextOffset > ciphertext.length) {
            throw new IllegalArgumentException();
        }
        int space = ciphertext.length - ciphertextOffset;
        if (length > space) {
            throw new ShortBufferException();
        }
        if (length < 0 || plaintextOffset < 0 || plaintextOffset > plaintext.length || length > ciphertext.length || ciphertext.length - ciphertextOffset < length) {
            throw new IllegalArgumentException();
        }
        space = plaintext.length - plaintextOffset;
        if (!this.haskey) {
            if (length > space) {
                throw new ShortBufferException();
            }
            if (plaintext != ciphertext || plaintextOffset != ciphertextOffset) {
                System.arraycopy(ciphertext, ciphertextOffset, plaintext, plaintextOffset, length);
            }
            return length;
        }
        if (length < 16) {
            Noise.throwBadTagException();
        }
        if ((dataLen = length - 16) > space) {
            throw new ShortBufferException();
        }
        this.setup(ad);
        this.ghash.update(ciphertext, ciphertextOffset, dataLen);
        this.ghash.pad(ad != null ? (long)ad.length : 0L, dataLen);
        this.ghash.finish(this.enciv, 0, 16);
        int temp = 0;
        for (int index = 0; index < 16; ++index) {
            temp |= this.hashKey[index] ^ this.enciv[index] ^ ciphertext[ciphertextOffset + dataLen + index];
        }
        if ((temp & 0xFF) != 0) {
            Noise.throwBadTagException();
        }
        this.encryptCTR(ciphertext, ciphertextOffset, plaintext, plaintextOffset, dataLen);
        ++this.n;
        return dataLen;
    }

    @Override
    public CipherState fork(byte[] key, int offset) {
        AESGCMFallbackCipherState cipher = new AESGCMFallbackCipherState();
        cipher.initializeKey(key, offset);
        return cipher;
    }

    @Override
    public void setNonce(long nonce) {
        this.n = nonce;
    }
}

