/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.crypto.GHASH;
import com.southernstorm.noise.protocol.CipherState;
import com.southernstorm.noise.protocol.Noise;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class AESGCMOnCtrCipherState
implements CipherState {
    private Cipher cipher;
    private SecretKeySpec keySpec;
    private long n;
    private byte[] iv;
    private byte[] hashKey;
    private GHASH ghash;

    public AESGCMOnCtrCipherState() throws NoSuchAlgorithmException {
        try {
            this.cipher = Cipher.getInstance("AES/CTR/NoPadding");
        }
        catch (NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException("AES/CTR/NoPadding not available", e);
        }
        this.keySpec = null;
        this.n = 0L;
        this.iv = new byte[16];
        this.hashKey = new byte[16];
        this.ghash = new GHASH();
        try {
            SecretKeySpec spec = new SecretKeySpec(new byte[32], "AES");
            IvParameterSpec params = new IvParameterSpec(this.iv);
            this.cipher.init(1, (Key)spec, params);
        }
        catch (InvalidKeyException e) {
            throw new NoSuchAlgorithmException("AES/CTR/NoPadding does not support 256-bit keys", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new NoSuchAlgorithmException("AES/CTR/NoPadding does not support 256-bit keys", e);
        }
    }

    @Override
    public void destroy() {
        this.ghash.destroy();
        Noise.destroy(this.hashKey);
        Noise.destroy(this.iv);
        this.keySpec = new SecretKeySpec(new byte[32], "AES");
        IvParameterSpec params = new IvParameterSpec(this.iv);
        try {
            this.cipher.init(1, (Key)this.keySpec, params);
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    @Override
    public String getCipherName() {
        return "AESGCM";
    }

    @Override
    public int getKeyLength() {
        return 32;
    }

    @Override
    public int getMACLength() {
        return this.keySpec != null ? 16 : 0;
    }

    @Override
    public void initializeKey(byte[] key, int offset) {
        this.keySpec = new SecretKeySpec(key, offset, 32, "AES");
        Arrays.fill(this.iv, (byte)0);
        Arrays.fill(this.hashKey, (byte)0);
        try {
            this.cipher.init(1, (Key)this.keySpec, new IvParameterSpec(this.iv));
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalStateException(e);
        }
        try {
            int result = this.cipher.update(this.hashKey, 0, 16, this.hashKey, 0);
            this.cipher.doFinal(this.hashKey, result);
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException(e);
        }
        this.ghash.reset(this.hashKey, 0);
        this.n = 0L;
    }

    @Override
    public boolean hasKey() {
        return this.keySpec != null;
    }

    private void setup(byte[] ad) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.n == -1L) {
            throw new IllegalStateException("Nonce has wrapped around");
        }
        this.iv[0] = 0;
        this.iv[1] = 0;
        this.iv[2] = 0;
        this.iv[3] = 0;
        this.iv[4] = (byte)(this.n >> 56);
        this.iv[5] = (byte)(this.n >> 48);
        this.iv[6] = (byte)(this.n >> 40);
        this.iv[7] = (byte)(this.n >> 32);
        this.iv[8] = (byte)(this.n >> 24);
        this.iv[9] = (byte)(this.n >> 16);
        this.iv[10] = (byte)(this.n >> 8);
        this.iv[11] = (byte)this.n;
        this.iv[12] = 0;
        this.iv[13] = 0;
        this.iv[14] = 0;
        this.iv[15] = 1;
        this.cipher.init(1, (Key)this.keySpec, new IvParameterSpec(this.iv));
        Arrays.fill(this.hashKey, (byte)0);
        try {
            this.cipher.update(this.hashKey, 0, 16, this.hashKey, 0);
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException(e);
        }
        this.ghash.reset();
        if (ad != null) {
            this.ghash.update(ad, 0, ad.length);
            this.ghash.pad();
        }
    }

    @Override
    public int encryptWithAd(byte[] ad, byte[] plaintext, int plaintextOffset, byte[] ciphertext, int ciphertextOffset, int length) throws ShortBufferException {
        if (ciphertextOffset < 0 || ciphertextOffset > ciphertext.length) {
            throw new IllegalArgumentException();
        }
        if (length < 0 || plaintextOffset < 0 || plaintextOffset > plaintext.length || length > plaintext.length || plaintext.length - plaintextOffset < length) {
            throw new IllegalArgumentException();
        }
        int space = ciphertext.length - ciphertextOffset;
        if (this.keySpec == null) {
            if (length > space) {
                throw new ShortBufferException();
            }
            if (plaintext != ciphertext || plaintextOffset != ciphertextOffset) {
                System.arraycopy(plaintext, plaintextOffset, ciphertext, ciphertextOffset, length);
            }
            return length;
        }
        if (space < 16 || length > space - 16) {
            throw new ShortBufferException();
        }
        try {
            this.setup(ad);
            int result = this.cipher.update(plaintext, plaintextOffset, length, ciphertext, ciphertextOffset);
            this.cipher.doFinal(ciphertext, ciphertextOffset + result);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException(e);
        }
        this.ghash.update(ciphertext, ciphertextOffset, length);
        this.ghash.pad(ad != null ? (long)ad.length : 0L, length);
        this.ghash.finish(ciphertext, ciphertextOffset + length, 16);
        for (int index = 0; index < 16; ++index) {
            int n = ciphertextOffset + length + index;
            ciphertext[n] = (byte)(ciphertext[n] ^ this.hashKey[index]);
        }
        ++this.n;
        return length + 16;
    }

    @Override
    public int decryptWithAd(byte[] ad, byte[] ciphertext, int ciphertextOffset, byte[] plaintext, int plaintextOffset, int length) throws ShortBufferException, BadPaddingException {
        int dataLen;
        if (ciphertextOffset < 0 || ciphertextOffset > ciphertext.length) {
            throw new IllegalArgumentException();
        }
        int space = ciphertext.length - ciphertextOffset;
        if (length > space) {
            throw new ShortBufferException();
        }
        if (length < 0 || plaintextOffset < 0 || plaintextOffset > plaintext.length || length > ciphertext.length || ciphertext.length - ciphertextOffset < length) {
            throw new IllegalArgumentException();
        }
        space = plaintext.length - plaintextOffset;
        if (this.keySpec == null) {
            if (length > space) {
                throw new ShortBufferException();
            }
            if (plaintext != ciphertext || plaintextOffset != ciphertextOffset) {
                System.arraycopy(ciphertext, ciphertextOffset, plaintext, plaintextOffset, length);
            }
            return length;
        }
        if (length < 16) {
            Noise.throwBadTagException();
        }
        if ((dataLen = length - 16) > space) {
            throw new ShortBufferException();
        }
        try {
            this.setup(ad);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalStateException(e);
        }
        this.ghash.update(ciphertext, ciphertextOffset, dataLen);
        this.ghash.pad(ad != null ? (long)ad.length : 0L, dataLen);
        this.ghash.finish(this.iv, 0, 16);
        int temp = 0;
        for (int index = 0; index < 16; ++index) {
            temp |= this.hashKey[index] ^ this.iv[index] ^ ciphertext[ciphertextOffset + dataLen + index];
        }
        if ((temp & 0xFF) != 0) {
            Noise.throwBadTagException();
        }
        try {
            int result = this.cipher.update(ciphertext, ciphertextOffset, dataLen, plaintext, plaintextOffset);
            this.cipher.doFinal(plaintext, plaintextOffset + result);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException(e);
        }
        ++this.n;
        return dataLen;
    }

    @Override
    public CipherState fork(byte[] key, int offset) {
        AESGCMOnCtrCipherState cipher;
        try {
            cipher = new AESGCMOnCtrCipherState();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        cipher.initializeKey(key, offset);
        return cipher;
    }

    @Override
    public void setNonce(long nonce) {
        this.n = nonce;
    }
}

