/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.protocol.CipherState;
import com.southernstorm.noise.protocol.Destroyable;

public final class CipherStatePair
implements Destroyable {
    private CipherState send;
    private CipherState recv;

    public CipherStatePair(CipherState sender, CipherState receiver) {
        this.send = sender;
        this.recv = receiver;
    }

    public CipherState getSender() {
        return this.send;
    }

    public CipherState getReceiver() {
        return this.recv;
    }

    public void senderOnly() {
        if (this.recv != null) {
            this.recv.destroy();
            this.recv = null;
        }
    }

    public void receiverOnly() {
        if (this.send != null) {
            this.send.destroy();
            this.send = null;
        }
    }

    public void swap() {
        CipherState temp = this.send;
        this.send = this.recv;
        this.recv = temp;
    }

    @Override
    public void destroy() {
        this.senderOnly();
        this.receiverOnly();
    }
}

