/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.crypto.Curve25519;
import com.southernstorm.noise.protocol.DHState;
import com.southernstorm.noise.protocol.Noise;
import java.util.Arrays;

class Curve25519DHState
implements DHState {
    private byte[] publicKey = new byte[32];
    private byte[] privateKey = new byte[32];
    private int mode = 0;

    @Override
    public void destroy() {
        this.clearKey();
    }

    @Override
    public String getDHName() {
        return "25519";
    }

    @Override
    public int getPublicKeyLength() {
        return 32;
    }

    @Override
    public int getPrivateKeyLength() {
        return 32;
    }

    @Override
    public int getSharedKeyLength() {
        return 32;
    }

    @Override
    public void generateKeyPair() {
        Noise.random(this.privateKey);
        Curve25519.eval(this.publicKey, 0, this.privateKey, null);
        this.mode = 3;
    }

    @Override
    public void getPublicKey(byte[] key, int offset) {
        System.arraycopy(this.publicKey, 0, key, offset, 32);
    }

    @Override
    public void setPublicKey(byte[] key, int offset) {
        System.arraycopy(key, offset, this.publicKey, 0, 32);
        Arrays.fill(this.privateKey, (byte)0);
        this.mode = 1;
    }

    @Override
    public void getPrivateKey(byte[] key, int offset) {
        System.arraycopy(this.privateKey, 0, key, offset, 32);
    }

    @Override
    public void setPrivateKey(byte[] key, int offset) {
        System.arraycopy(key, offset, this.privateKey, 0, 32);
        Curve25519.eval(this.publicKey, 0, this.privateKey, null);
        this.mode = 3;
    }

    @Override
    public void setToNullPublicKey() {
        Arrays.fill(this.publicKey, (byte)0);
        Arrays.fill(this.privateKey, (byte)0);
        this.mode = 1;
    }

    @Override
    public void clearKey() {
        Noise.destroy(this.publicKey);
        Noise.destroy(this.privateKey);
        this.mode = 0;
    }

    @Override
    public boolean hasPublicKey() {
        return (this.mode & 1) != 0;
    }

    @Override
    public boolean hasPrivateKey() {
        return (this.mode & 2) != 0;
    }

    @Override
    public boolean isNullPublicKey() {
        if ((this.mode & 1) == 0) {
            return false;
        }
        int temp = 0;
        for (int index = 0; index < 32; ++index) {
            temp |= this.publicKey[index];
        }
        return temp == 0;
    }

    @Override
    public void calculate(byte[] sharedKey, int offset, DHState publicDH) {
        if (!(publicDH instanceof Curve25519DHState)) {
            throw new IllegalArgumentException("Incompatible DH algorithms");
        }
        Curve25519.eval(sharedKey, offset, this.privateKey, ((Curve25519DHState)publicDH).publicKey);
    }

    @Override
    public void copyFrom(DHState other) {
        if (!(other instanceof Curve25519DHState)) {
            throw new IllegalStateException("Mismatched DH key objects");
        }
        if (other == this) {
            return;
        }
        Curve25519DHState dh = (Curve25519DHState)other;
        System.arraycopy(dh.privateKey, 0, this.privateKey, 0, 32);
        System.arraycopy(dh.publicKey, 0, this.publicKey, 0, 32);
        this.mode = dh.mode;
    }
}

