/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.crypto.Curve448;
import com.southernstorm.noise.protocol.DHState;
import com.southernstorm.noise.protocol.Noise;
import java.util.Arrays;

class Curve448DHState
implements DHState {
    private byte[] publicKey = new byte[56];
    private byte[] privateKey = new byte[56];
    private int mode = 0;

    @Override
    public void destroy() {
        this.clearKey();
    }

    @Override
    public String getDHName() {
        return "448";
    }

    @Override
    public int getPublicKeyLength() {
        return 56;
    }

    @Override
    public int getPrivateKeyLength() {
        return 56;
    }

    @Override
    public int getSharedKeyLength() {
        return 56;
    }

    @Override
    public void generateKeyPair() {
        Noise.random(this.privateKey);
        Curve448.eval(this.publicKey, 0, this.privateKey, null);
        this.mode = 3;
    }

    @Override
    public void getPublicKey(byte[] key, int offset) {
        System.arraycopy(this.publicKey, 0, key, offset, 56);
    }

    @Override
    public void setPublicKey(byte[] key, int offset) {
        System.arraycopy(key, offset, this.publicKey, 0, 56);
        Arrays.fill(this.privateKey, (byte)0);
        this.mode = 1;
    }

    @Override
    public void getPrivateKey(byte[] key, int offset) {
        System.arraycopy(this.privateKey, 0, key, offset, 56);
    }

    @Override
    public void setPrivateKey(byte[] key, int offset) {
        System.arraycopy(key, offset, this.privateKey, 0, 56);
        Curve448.eval(this.publicKey, 0, this.privateKey, null);
        this.mode = 3;
    }

    @Override
    public void setToNullPublicKey() {
        Arrays.fill(this.publicKey, (byte)0);
        Arrays.fill(this.privateKey, (byte)0);
        this.mode = 1;
    }

    @Override
    public void clearKey() {
        Noise.destroy(this.publicKey);
        Noise.destroy(this.privateKey);
        this.mode = 0;
    }

    @Override
    public boolean hasPublicKey() {
        return (this.mode & 1) != 0;
    }

    @Override
    public boolean hasPrivateKey() {
        return (this.mode & 2) != 0;
    }

    @Override
    public boolean isNullPublicKey() {
        if ((this.mode & 1) == 0) {
            return false;
        }
        int temp = 0;
        for (int index = 0; index < 56; ++index) {
            temp |= this.publicKey[index];
        }
        return temp == 0;
    }

    @Override
    public void calculate(byte[] sharedKey, int offset, DHState publicDH) {
        if (!(publicDH instanceof Curve448DHState)) {
            throw new IllegalArgumentException("Incompatible DH algorithms");
        }
        Curve448.eval(sharedKey, offset, this.privateKey, ((Curve448DHState)publicDH).publicKey);
    }

    @Override
    public void copyFrom(DHState other) {
        if (!(other instanceof Curve448DHState)) {
            throw new IllegalStateException("Mismatched DH key objects");
        }
        if (other == this) {
            return;
        }
        Curve448DHState dh = (Curve448DHState)other;
        System.arraycopy(dh.privateKey, 0, this.privateKey, 0, 56);
        System.arraycopy(dh.publicKey, 0, this.publicKey, 0, 56);
        this.mode = dh.mode;
    }
}

