/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.protocol.CipherStatePair;
import com.southernstorm.noise.protocol.DHState;
import com.southernstorm.noise.protocol.DHStateHybrid;
import com.southernstorm.noise.protocol.Destroyable;
import com.southernstorm.noise.protocol.Noise;
import com.southernstorm.noise.protocol.Pattern;
import com.southernstorm.noise.protocol.SymmetricState;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.ShortBufferException;

public class HandshakeState
implements Destroyable {
    private SymmetricState symmetric;
    private boolean isInitiator;
    private DHState localKeyPair;
    private DHState localEphemeral;
    private DHState localHybrid;
    private DHState remotePublicKey;
    private DHState remoteEphemeral;
    private DHState remoteHybrid;
    private DHState fixedEphemeral;
    private DHState fixedHybrid;
    private int action;
    private int requirements;
    private short[] pattern;
    private int patternIndex;
    private byte[] preSharedKey;
    private byte[] prologue;
    public static final int INITIATOR = 1;
    public static final int RESPONDER = 2;
    public static final int NO_ACTION = 0;
    public static final int WRITE_MESSAGE = 1;
    public static final int READ_MESSAGE = 2;
    public static final int FAILED = 3;
    public static final int SPLIT = 4;
    public static final int COMPLETE = 5;
    private static final int LOCAL_REQUIRED = 1;
    private static final int REMOTE_REQUIRED = 2;
    private static final int PSK_REQUIRED = 4;
    private static final int FALLBACK_PREMSG = 8;
    private static final int LOCAL_PREMSG = 16;
    private static final int REMOTE_PREMSG = 32;
    private static final int FALLBACK_POSSIBLE = 64;
    private static final byte[] emptyPrologue = new byte[0];

    public HandshakeState(String protocolName, int role) throws NoSuchAlgorithmException {
        int index;
        String[] components = protocolName.split("_");
        if (components.length != 5) {
            throw new IllegalArgumentException("Protocol name must have 5 components");
        }
        String prefix = components[0];
        String patternId = components[1];
        String dh = components[2];
        String hybrid = null;
        String cipher = components[3];
        String hash = components[4];
        if (!prefix.equals("Noise") && !prefix.equals("NoisePSK")) {
            throw new IllegalArgumentException("Prefix must be Noise or NoisePSK");
        }
        this.pattern = Pattern.lookup(patternId);
        if (this.pattern == null) {
            throw new IllegalArgumentException("Handshake pattern is not recognized");
        }
        short flags = this.pattern[0];
        int extraReqs = 0;
        if ((flags & 0x400) != 0 && patternId.length() > 1) {
            extraReqs |= 0x40;
        }
        if (role == 2) {
            flags = Pattern.reverseFlags(flags);
        }
        if ((index = dh.indexOf(43)) != -1) {
            hybrid = dh.substring(index + 1);
            dh = dh.substring(0, index);
            if ((flags & 0x10) == 0 || (flags & 0x1000) == 0) {
                throw new IllegalArgumentException("Hybrid function specified for non-hybrid pattern");
            }
        } else if ((flags & 0x10) != 0 || (flags & 0x1000) != 0) {
            throw new IllegalArgumentException("Hybrid function not specified for hybrid pattern");
        }
        if (role != 1 && role != 2) {
            throw new IllegalArgumentException("Role must be initiator or responder");
        }
        this.symmetric = new SymmetricState(protocolName, cipher, hash);
        this.isInitiator = role == 1;
        this.action = 0;
        this.requirements = extraReqs | HandshakeState.computeRequirements(flags, prefix, role, false);
        this.patternIndex = 1;
        if ((flags & 1) != 0) {
            this.localKeyPair = Noise.createDH(dh);
        }
        if ((flags & 2) != 0) {
            this.localEphemeral = Noise.createDH(dh);
        }
        if ((flags & 0x10) != 0) {
            this.localHybrid = Noise.createDH(hybrid);
        }
        if ((flags & 0x100) != 0) {
            this.remotePublicKey = Noise.createDH(dh);
        }
        if ((flags & 0x200) != 0) {
            this.remoteEphemeral = Noise.createDH(dh);
        }
        if ((flags & 0x1000) != 0) {
            this.remoteHybrid = Noise.createDH(hybrid);
        }
        if (this.localKeyPair instanceof DHStateHybrid) {
            throw new NoSuchAlgorithmException("Cannot use '" + this.localKeyPair.getDHName() + "' for static keys");
        }
        if (this.localEphemeral instanceof DHStateHybrid) {
            throw new NoSuchAlgorithmException("Cannot use '" + this.localEphemeral.getDHName() + "' for ephemeral keys");
        }
        if (this.remotePublicKey instanceof DHStateHybrid) {
            throw new NoSuchAlgorithmException("Cannot use '" + this.remotePublicKey.getDHName() + "' for static keys");
        }
        if (this.remoteEphemeral instanceof DHStateHybrid) {
            throw new NoSuchAlgorithmException("Cannot use '" + this.remoteEphemeral.getDHName() + "' for ephemeral keys");
        }
    }

    public String getProtocolName() {
        return this.symmetric.getProtocolName();
    }

    public int getRole() {
        return this.isInitiator ? 1 : 2;
    }

    public boolean needsPreSharedKey() {
        if (this.preSharedKey != null) {
            return false;
        }
        return (this.requirements & 4) != 0;
    }

    public boolean hasPreSharedKey() {
        return this.preSharedKey != null;
    }

    public void setPreSharedKey(byte[] key, int offset, int length) {
        if (length != 32) {
            throw new IllegalArgumentException("Pre-shared keys must be 32 bytes in length");
        }
        if ((this.requirements & 4) == 0) {
            throw new UnsupportedOperationException("Pre-shared keys are not supported for this handshake");
        }
        if (this.action != 0) {
            throw new IllegalStateException("Handshake has already started; cannot set pre-shared key");
        }
        if (this.preSharedKey != null) {
            Noise.destroy(this.preSharedKey);
            this.preSharedKey = null;
        }
        this.preSharedKey = Noise.copySubArray(key, offset, length);
    }

    public void setPrologue(byte[] prologue, int offset, int length) {
        if (this.action != 0) {
            throw new IllegalStateException("Handshake has already started; cannot set prologue");
        }
        if (this.prologue != null) {
            Noise.destroy(this.prologue);
            this.prologue = null;
        }
        this.prologue = Noise.copySubArray(prologue, offset, length);
    }

    public DHState getLocalKeyPair() {
        return this.localKeyPair;
    }

    public boolean needsLocalKeyPair() {
        if (this.localKeyPair != null) {
            return !this.localKeyPair.hasPrivateKey();
        }
        return false;
    }

    public boolean hasLocalKeyPair() {
        if (this.localKeyPair != null) {
            return this.localKeyPair.hasPrivateKey();
        }
        return false;
    }

    public DHState getRemotePublicKey() {
        return this.remotePublicKey;
    }

    public boolean needsRemotePublicKey() {
        if (this.remotePublicKey != null) {
            return !this.remotePublicKey.hasPublicKey();
        }
        return false;
    }

    public boolean hasRemotePublicKey() {
        if (this.remotePublicKey != null) {
            return this.remotePublicKey.hasPublicKey();
        }
        return false;
    }

    public DHState getFixedEphemeralKey() {
        if (this.fixedEphemeral != null) {
            return this.fixedEphemeral;
        }
        if (this.localEphemeral == null) {
            return null;
        }
        try {
            this.fixedEphemeral = Noise.createDH(this.localEphemeral.getDHName());
        }
        catch (NoSuchAlgorithmException e) {
            this.fixedEphemeral = null;
        }
        return this.fixedEphemeral;
    }

    public DHState getFixedHybridKey() {
        if (this.fixedHybrid != null) {
            return this.fixedHybrid;
        }
        if (this.localHybrid == null) {
            return null;
        }
        try {
            this.fixedHybrid = Noise.createDH(this.localHybrid.getDHName());
        }
        catch (NoSuchAlgorithmException e) {
            this.fixedHybrid = null;
        }
        return this.fixedHybrid;
    }

    public void start() {
        if (this.action != 0) {
            throw new IllegalStateException("Handshake has already started; cannot start again");
        }
        if ((this.pattern[0] & 0x800) != 0 && (this.requirements & 8) == 0) {
            throw new UnsupportedOperationException("Cannot start a fallback pattern");
        }
        if (!((this.requirements & 1) == 0 || this.localKeyPair != null && this.localKeyPair.hasPrivateKey())) {
            throw new IllegalStateException("Local static key required");
        }
        if (!((this.requirements & 2) == 0 || this.remotePublicKey != null && this.remotePublicKey.hasPublicKey())) {
            throw new IllegalStateException("Remote static key required");
        }
        if ((this.requirements & 4) != 0 && this.preSharedKey == null) {
            throw new IllegalStateException("Pre-shared key required");
        }
        if (this.prologue != null) {
            this.symmetric.mixHash(this.prologue, 0, this.prologue.length);
        } else {
            this.symmetric.mixHash(emptyPrologue, 0, 0);
        }
        if (this.preSharedKey != null) {
            this.symmetric.mixPreSharedKey(this.preSharedKey);
        }
        if (this.isInitiator) {
            if ((this.requirements & 0x10) != 0) {
                this.symmetric.mixPublicKey(this.localKeyPair);
            }
            if ((this.requirements & 8) != 0) {
                this.symmetric.mixPublicKey(this.remoteEphemeral);
                if (this.remoteHybrid != null) {
                    this.symmetric.mixPublicKey(this.remoteHybrid);
                }
                if (this.preSharedKey != null) {
                    this.symmetric.mixPublicKeyIntoCK(this.remoteEphemeral);
                }
            }
            if ((this.requirements & 0x20) != 0) {
                this.symmetric.mixPublicKey(this.remotePublicKey);
            }
        } else {
            if ((this.requirements & 0x20) != 0) {
                this.symmetric.mixPublicKey(this.remotePublicKey);
            }
            if ((this.requirements & 8) != 0) {
                this.symmetric.mixPublicKey(this.localEphemeral);
                if (this.localHybrid != null) {
                    this.symmetric.mixPublicKey(this.localHybrid);
                }
                if (this.preSharedKey != null) {
                    this.symmetric.mixPublicKeyIntoCK(this.localEphemeral);
                }
            }
            if ((this.requirements & 0x10) != 0) {
                this.symmetric.mixPublicKey(this.localKeyPair);
            }
        }
        this.action = this.isInitiator ? 1 : 2;
    }

    public void fallback() throws NoSuchAlgorithmException {
        this.fallback("XXfallback");
    }

    public void fallback(String patternName) throws NoSuchAlgorithmException {
        if ((this.requirements & 0x40) == 0) {
            throw new UnsupportedOperationException("Previous handshake pattern does not support fallback");
        }
        short[] newPattern = Pattern.lookup(patternName);
        if (newPattern == null || (newPattern[0] & 0x800) == 0) {
            throw new UnsupportedOperationException("New pattern is not a fallback pattern");
        }
        if (this.isInitiator) {
            if (this.action != 3 && this.action != 2 || !this.localEphemeral.hasPublicKey()) {
                throw new IllegalStateException("Initiator cannot fall back from this state");
            }
        } else if (this.action != 3 && this.action != 1 || !this.remoteEphemeral.hasPublicKey()) {
            throw new IllegalStateException("Responder cannot fall back from this state");
        }
        String[] components = this.symmetric.getProtocolName().split("_");
        components[1] = patternName;
        StringBuilder builder = new StringBuilder();
        builder.append(components[0]);
        for (int index = 1; index < components.length; ++index) {
            builder.append('_');
            builder.append(components[index]);
        }
        String name = builder.toString();
        SymmetricState newSymmetric = new SymmetricState(name, components[3], components[4]);
        this.symmetric.destroy();
        this.symmetric = newSymmetric;
        if (this.isInitiator) {
            if (this.remoteEphemeral != null) {
                this.remoteEphemeral.clearKey();
            }
            if (this.remoteHybrid != null) {
                this.remoteHybrid.clearKey();
            }
            if (this.remotePublicKey != null) {
                this.remotePublicKey.clearKey();
            }
            this.isInitiator = false;
        } else {
            if (this.localEphemeral != null) {
                this.localEphemeral.clearKey();
            }
            if (this.localHybrid != null) {
                this.localHybrid.clearKey();
            }
            if ((newPattern[0] & 0x400) == 0 && this.remotePublicKey != null) {
                this.remotePublicKey.clearKey();
            }
            this.isInitiator = true;
        }
        this.action = 0;
        this.pattern = newPattern;
        this.patternIndex = 1;
        short flags = this.pattern[0];
        if (!this.isInitiator) {
            flags = Pattern.reverseFlags(flags);
        }
        this.requirements = HandshakeState.computeRequirements(flags, components[0], this.isInitiator ? 1 : 2, true);
    }

    public int getAction() {
        return this.action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mixDH(DHState local, DHState remote) {
        if (local == null || remote == null) {
            throw new IllegalStateException("Pattern definition error");
        }
        int len = local.getSharedKeyLength();
        byte[] shared = new byte[len];
        try {
            local.calculate(shared, 0, remote);
            this.symmetric.mixKey(shared, 0, len);
        }
        finally {
            Noise.destroy(shared);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeMessage(byte[] message, int messageOffset, byte[] payload, int payloadOffset, int payloadLength) throws ShortBufferException {
        messagePosn = messageOffset;
        success = false;
        if (this.action != 1) {
            throw new IllegalStateException("Handshake state does not allow writing messages");
        }
        if (payload == null) {
            if (payloadOffset != 0) throw new IllegalArgumentException("Invalid payload argument");
            if (payloadLength != 0) {
                throw new IllegalArgumentException("Invalid payload argument");
            }
        }
        if (messageOffset > message.length) {
            throw new ShortBufferException();
        }
        try {
            block37: {
                block13: while (true) {
                    if (this.patternIndex >= this.pattern.length) {
                        this.action = 4;
                        break block37;
                    }
                    if ((token = this.pattern[this.patternIndex++]) == 255) {
                        this.action = 2;
                        break block37;
                    }
                    space = message.length - messagePosn;
                    switch (token) {
                        case 2: {
                            if (this.localEphemeral == null) {
                                throw new IllegalStateException("Pattern definition error");
                            }
                            if (this.fixedEphemeral == null) {
                                this.localEphemeral.generateKeyPair();
                            } else {
                                this.localEphemeral.copyFrom(this.fixedEphemeral);
                            }
                            len = this.localEphemeral.getPublicKeyLength();
                            if (space < len) {
                                throw new ShortBufferException();
                            }
                            this.localEphemeral.getPublicKey(message, messagePosn);
                            this.symmetric.mixHash(message, messagePosn, len);
                            if (this.preSharedKey != null) {
                                this.symmetric.mixKey(message, messagePosn, len);
                            }
                            messagePosn += len;
                            continue block13;
                        }
                        case 1: {
                            if (this.localKeyPair == null) {
                                throw new IllegalStateException("Pattern definition error");
                            }
                            len = this.localKeyPair.getPublicKeyLength();
                            if (space < len + (macLen = this.symmetric.getMACLength())) {
                                throw new ShortBufferException();
                            }
                            this.localKeyPair.getPublicKey(message, messagePosn);
                            messagePosn += this.symmetric.encryptAndHash(message, messagePosn, message, messagePosn, len);
                            continue block13;
                        }
                        case 3: {
                            this.mixDH(this.localEphemeral, this.remoteEphemeral);
                            continue block13;
                        }
                        case 4: {
                            if (this.isInitiator) {
                                this.mixDH(this.localEphemeral, this.remotePublicKey);
                                continue block13;
                            }
                            this.mixDH(this.localKeyPair, this.remoteEphemeral);
                            continue block13;
                        }
                        case 5: {
                            if (this.isInitiator) {
                                this.mixDH(this.localKeyPair, this.remoteEphemeral);
                                continue block13;
                            }
                            this.mixDH(this.localEphemeral, this.remotePublicKey);
                            continue block13;
                        }
                        case 6: {
                            this.mixDH(this.localKeyPair, this.remotePublicKey);
                            continue block13;
                        }
                        case 7: {
                            if (this.localHybrid == null) {
                                throw new IllegalStateException("Pattern definition error");
                            }
                            if (!(this.localHybrid instanceof DHStateHybrid)) ** GOTO lbl74
                            hybrid = (DHStateHybrid)this.localHybrid;
                            if (this.fixedHybrid == null) {
                                hybrid.generateKeyPair(this.remoteHybrid);
                            } else {
                                hybrid.copyFrom(this.fixedHybrid, this.remoteHybrid);
                            }
                            ** GOTO lbl78
lbl74:
                            // 1 sources

                            if (this.fixedHybrid == null) {
                                this.localHybrid.generateKeyPair();
                            } else {
                                this.localHybrid.copyFrom(this.fixedHybrid);
                            }
lbl78:
                            // 4 sources

                            len = this.localHybrid.getPublicKeyLength();
                            if (space < len) {
                                throw new ShortBufferException();
                            }
                            macLen = this.symmetric.getMACLength();
                            if (space < len + macLen) {
                                throw new ShortBufferException();
                            }
                            this.localHybrid.getPublicKey(message, messagePosn);
                            messagePosn += this.symmetric.encryptAndHash(message, messagePosn, message, messagePosn, len);
                            continue block13;
                        }
                        case 8: {
                            this.mixDH(this.localHybrid, this.remoteHybrid);
                            continue block13;
                        }
                    }
                    break;
                }
                throw new IllegalStateException("Unknown handshake token " + Integer.toString(token));
            }
            messagePosn = payload != null ? (messagePosn += this.symmetric.encryptAndHash(payload, payloadOffset, message, messagePosn, payloadLength)) : (messagePosn += this.symmetric.encryptAndHash(message, messagePosn, message, messagePosn, 0));
            success = true;
            return messagePosn - messageOffset;
        }
        finally {
            if (!success) {
                Arrays.fill(message, messageOffset, message.length - messageOffset, (byte)0);
                this.action = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readMessage(byte[] message, int messageOffset, int messageLength, byte[] payload, int payloadOffset) throws ShortBufferException, BadPaddingException {
        boolean success = false;
        int messageEnd = messageOffset + messageLength;
        if (this.action != 2) {
            throw new IllegalStateException("Handshake state does not allow reading messages");
        }
        if (messageOffset > message.length) throw new ShortBufferException();
        if (payloadOffset > payload.length) {
            throw new ShortBufferException();
        }
        if (messageLength > message.length - messageOffset) {
            throw new ShortBufferException();
        }
        try {
            block39: {
                short token;
                block19: while (true) {
                    if (this.patternIndex >= this.pattern.length) {
                        this.action = 4;
                        break block39;
                    }
                    if ((token = this.pattern[this.patternIndex++]) == 255) {
                        this.action = 1;
                        break block39;
                    }
                    int space = messageEnd - messageOffset;
                    switch (token) {
                        case 2: {
                            if (this.remoteEphemeral == null) {
                                throw new IllegalStateException("Pattern definition error");
                            }
                            int len = this.remoteEphemeral.getPublicKeyLength();
                            if (space < len) {
                                throw new ShortBufferException();
                            }
                            this.symmetric.mixHash(message, messageOffset, len);
                            this.remoteEphemeral.setPublicKey(message, messageOffset);
                            if (this.remoteEphemeral.isNullPublicKey()) {
                                throw new BadPaddingException("Null remote public key");
                            }
                            if (this.preSharedKey != null) {
                                this.symmetric.mixKey(message, messageOffset, len);
                            }
                            messageOffset += len;
                            continue block19;
                        }
                        case 1: {
                            int macLen;
                            if (this.remotePublicKey == null) {
                                throw new IllegalStateException("Pattern definition error");
                            }
                            int len = this.remotePublicKey.getPublicKeyLength();
                            if (space < len + (macLen = this.symmetric.getMACLength())) {
                                throw new ShortBufferException();
                            }
                            byte[] temp = new byte[len];
                            try {
                                if (this.symmetric.decryptAndHash(message, messageOffset, temp, 0, len + macLen) != len) {
                                    throw new ShortBufferException();
                                }
                                this.remotePublicKey.setPublicKey(temp, 0);
                            }
                            finally {
                                Noise.destroy(temp);
                            }
                            messageOffset += len + macLen;
                            continue block19;
                        }
                        case 3: {
                            this.mixDH(this.localEphemeral, this.remoteEphemeral);
                            continue block19;
                        }
                        case 4: {
                            if (this.isInitiator) {
                                this.mixDH(this.localEphemeral, this.remotePublicKey);
                                continue block19;
                            }
                            this.mixDH(this.localKeyPair, this.remoteEphemeral);
                            continue block19;
                        }
                        case 5: {
                            if (this.isInitiator) {
                                this.mixDH(this.localKeyPair, this.remoteEphemeral);
                                continue block19;
                            }
                            this.mixDH(this.localEphemeral, this.remotePublicKey);
                            continue block19;
                        }
                        case 6: {
                            this.mixDH(this.localKeyPair, this.remotePublicKey);
                            continue block19;
                        }
                        case 7: {
                            int macLen;
                            int len;
                            if (this.remoteHybrid == null) {
                                throw new IllegalStateException("Pattern definition error");
                            }
                            if (this.remoteHybrid instanceof DHStateHybrid) {
                                ((DHStateHybrid)this.remoteHybrid).specifyPeer(this.localHybrid);
                            }
                            if (space < (len = this.remoteHybrid.getPublicKeyLength()) + (macLen = this.symmetric.getMACLength())) {
                                throw new ShortBufferException();
                            }
                            byte[] temp = new byte[len];
                            try {
                                if (this.symmetric.decryptAndHash(message, messageOffset, temp, 0, len + macLen) != len) {
                                    throw new ShortBufferException();
                                }
                                this.remoteHybrid.setPublicKey(temp, 0);
                            }
                            finally {
                                Noise.destroy(temp);
                            }
                            messageOffset += len + macLen;
                            continue block19;
                        }
                        case 8: {
                            this.mixDH(this.localHybrid, this.remoteHybrid);
                            continue block19;
                        }
                    }
                    break;
                }
                throw new IllegalStateException("Unknown handshake token " + Integer.toString(token));
            }
            int payloadLength = this.symmetric.decryptAndHash(message, messageOffset, payload, payloadOffset, messageEnd - messageOffset);
            success = true;
            int n = payloadLength;
            return n;
        }
        finally {
            if (!success) {
                Arrays.fill(payload, payloadOffset, payload.length - payloadOffset, (byte)0);
                this.action = 3;
            }
        }
    }

    public CipherStatePair split() {
        if (this.action != 4) {
            throw new IllegalStateException("Handshake has not finished");
        }
        CipherStatePair pair = this.symmetric.split();
        if (!this.isInitiator) {
            pair.swap();
        }
        this.action = 5;
        return pair;
    }

    public CipherStatePair split(byte[] secondaryKey, int offset, int length) {
        if (this.action != 4) {
            throw new IllegalStateException("Handshake has not finished");
        }
        CipherStatePair pair = this.symmetric.split(secondaryKey, offset, length);
        if (!this.isInitiator) {
            pair.swap();
        }
        this.action = 5;
        return pair;
    }

    public byte[] getHandshakeHash() {
        if (this.action != 4 && this.action != 5) {
            throw new IllegalStateException("Handshake has not completed");
        }
        return this.symmetric.getHandshakeHash();
    }

    @Override
    public void destroy() {
        if (this.symmetric != null) {
            this.symmetric.destroy();
        }
        if (this.localKeyPair != null) {
            this.localKeyPair.destroy();
        }
        if (this.localEphemeral != null) {
            this.localEphemeral.destroy();
        }
        if (this.localHybrid != null) {
            this.localHybrid.destroy();
        }
        if (this.remotePublicKey != null) {
            this.remotePublicKey.destroy();
        }
        if (this.remoteEphemeral != null) {
            this.remoteEphemeral.destroy();
        }
        if (this.remoteHybrid != null) {
            this.remoteHybrid.destroy();
        }
        if (this.fixedEphemeral != null) {
            this.fixedEphemeral.destroy();
        }
        if (this.fixedHybrid != null) {
            this.fixedHybrid.destroy();
        }
        if (this.preSharedKey != null) {
            Noise.destroy(this.preSharedKey);
        }
        if (this.prologue != null) {
            Noise.destroy(this.prologue);
        }
    }

    private static int computeRequirements(short flags, String prefix, int role, boolean isFallback) {
        int requirements = 0;
        if ((flags & 1) != 0) {
            requirements |= 1;
        }
        if ((flags & 4) != 0) {
            requirements |= 1;
            requirements |= 0x10;
        }
        if ((flags & 0x400) != 0) {
            requirements |= 2;
            requirements |= 0x20;
        }
        if ((flags & 0x808) != 0 && isFallback) {
            requirements |= 8;
        }
        if (prefix.equals("NoisePSK")) {
            requirements |= 4;
        }
        return requirements;
    }
}

