/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.crypto.NewHopeTor;
import com.southernstorm.noise.protocol.DHState;
import com.southernstorm.noise.protocol.DHStateHybrid;
import com.southernstorm.noise.protocol.Noise;
import java.util.Arrays;

final class NewHopeDHState
implements DHStateHybrid {
    private NewHopeTor nh = null;
    private byte[] publicKey = null;
    private byte[] privateKey = null;
    private KeyType keyType = KeyType.None;

    private boolean isAlice() {
        return this.keyType == KeyType.AlicePrivate || this.keyType == KeyType.AlicePublic;
    }

    @Override
    public void destroy() {
        this.clearKey();
    }

    @Override
    public String getDHName() {
        return "NewHope";
    }

    @Override
    public int getPublicKeyLength() {
        if (this.isAlice()) {
            return 1824;
        }
        return 2048;
    }

    @Override
    public int getPrivateKeyLength() {
        if (this.isAlice()) {
            return 64;
        }
        return 32;
    }

    @Override
    public int getSharedKeyLength() {
        return 32;
    }

    @Override
    public void generateKeyPair() {
        this.clearKey();
        this.keyType = KeyType.AlicePrivate;
        this.nh = new NewHopeTor();
        this.publicKey = new byte[1824];
        this.nh.keygen(this.publicKey, 0);
    }

    @Override
    public void generateKeyPair(DHState remote) {
        if (remote == null) {
            this.generateKeyPair();
            return;
        }
        if (!(remote instanceof NewHopeDHState)) {
            throw new IllegalStateException("Mismatched DH objects");
        }
        NewHopeDHState r = (NewHopeDHState)remote;
        if (r.isAlice() && r.publicKey != null) {
            this.clearKey();
            this.keyType = KeyType.BobCalculated;
            this.nh = new NewHopeTor();
            this.publicKey = new byte[2048];
            this.privateKey = new byte[32];
            this.nh.sharedb(this.privateKey, 0, this.publicKey, 0, r.publicKey, 0);
        } else {
            this.generateKeyPair();
        }
    }

    @Override
    public void getPublicKey(byte[] key, int offset) {
        if (this.publicKey != null) {
            System.arraycopy(this.publicKey, 0, key, offset, this.getPublicKeyLength());
        } else {
            Arrays.fill(key, 0, this.getPublicKeyLength(), (byte)0);
        }
    }

    @Override
    public void setPublicKey(byte[] key, int offset) {
        if (this.publicKey != null) {
            Noise.destroy(this.publicKey);
        }
        this.publicKey = new byte[this.getPublicKeyLength()];
        System.arraycopy(key, 0, this.publicKey, 0, this.publicKey.length);
    }

    @Override
    public void getPrivateKey(byte[] key, int offset) {
        if (this.privateKey != null) {
            System.arraycopy(this.privateKey, 0, key, offset, this.getPrivateKeyLength());
        } else {
            Arrays.fill(key, 0, this.getPrivateKeyLength(), (byte)0);
        }
    }

    @Override
    public void setPrivateKey(byte[] key, int offset) {
        this.clearKey();
        this.keyType = offset == 0 && key.length == 64 ? KeyType.AlicePrivate : KeyType.BobPrivate;
        this.privateKey = new byte[this.getPrivateKeyLength()];
        System.arraycopy(key, 0, this.privateKey, 0, this.privateKey.length);
    }

    @Override
    public void setToNullPublicKey() {
        this.clearKey();
    }

    @Override
    public void clearKey() {
        if (this.nh != null) {
            this.nh.destroy();
            this.nh = null;
        }
        if (this.publicKey != null) {
            Noise.destroy(this.publicKey);
            this.publicKey = null;
        }
        if (this.privateKey != null) {
            Noise.destroy(this.privateKey);
            this.privateKey = null;
        }
        this.keyType = KeyType.None;
    }

    @Override
    public boolean hasPublicKey() {
        return this.publicKey != null;
    }

    @Override
    public boolean hasPrivateKey() {
        return this.privateKey != null;
    }

    @Override
    public boolean isNullPublicKey() {
        return false;
    }

    @Override
    public void calculate(byte[] sharedKey, int offset, DHState publicDH) {
        if (!(publicDH instanceof NewHopeDHState)) {
            throw new IllegalArgumentException("Incompatible DH algorithms");
        }
        NewHopeDHState other = (NewHopeDHState)publicDH;
        if (this.keyType == KeyType.AlicePrivate) {
            this.nh.shareda(sharedKey, 0, other.publicKey, 0);
        } else if (this.keyType == KeyType.BobCalculated) {
            System.arraycopy(this.privateKey, 0, sharedKey, 0, 32);
        } else {
            throw new IllegalStateException("Cannot calculate with this DH object");
        }
    }

    @Override
    public void copyFrom(DHState other) {
        if (!(other instanceof NewHopeDHState)) {
            throw new IllegalStateException("Mismatched DH key objects");
        }
        if (other == this) {
            return;
        }
        NewHopeDHState dh = (NewHopeDHState)other;
        this.clearKey();
        switch (dh.keyType.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                if (dh.privateKey != null) {
                    this.keyType = KeyType.AlicePrivate;
                    this.privateKey = new byte[dh.privateKey.length];
                    System.arraycopy(dh.privateKey, 0, this.privateKey, 0, this.privateKey.length);
                    break;
                }
                throw new IllegalStateException("Cannot copy generated key for Alice");
            }
            case 3: 
            case 5: {
                throw new IllegalStateException("Cannot copy private key for Bob without public key for Alice");
            }
            case 2: 
            case 4: {
                this.keyType = dh.keyType;
                this.publicKey = new byte[dh.publicKey.length];
                System.arraycopy(dh.publicKey, 0, this.publicKey, 0, this.publicKey.length);
            }
        }
    }

    @Override
    public void copyFrom(DHState other, DHState remote) {
        if (remote == null) {
            this.copyFrom(other);
            return;
        }
        if (!(other instanceof NewHopeDHState) || !(remote instanceof NewHopeDHState)) {
            throw new IllegalStateException("Mismatched DH key objects");
        }
        if (other == this) {
            return;
        }
        NewHopeDHState dh = (NewHopeDHState)other;
        NewHopeDHState remotedh = (NewHopeDHState)remote;
        this.clearKey();
        switch (dh.keyType.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                if (dh.privateKey != null) {
                    this.keyType = KeyType.AlicePrivate;
                    this.nh = new NewHopeWithPrivateKey(dh.privateKey);
                    this.publicKey = new byte[1824];
                    this.nh.keygen(this.publicKey, 0);
                    break;
                }
                throw new IllegalStateException("Cannot copy generated key for Alice");
            }
            case 3: {
                if (dh.privateKey != null && remotedh.keyType == KeyType.AlicePublic) {
                    this.keyType = KeyType.BobCalculated;
                    this.nh = new NewHopeWithPrivateKey(dh.privateKey);
                    this.publicKey = new byte[2048];
                    this.privateKey = new byte[32];
                    this.nh.sharedb(this.privateKey, 0, this.publicKey, 0, remotedh.publicKey, 0);
                    break;
                }
                throw new IllegalStateException("Cannot copy private key for Bob without public key for Alice");
            }
            case 5: {
                throw new IllegalStateException("Cannot copy generated key for Bob");
            }
            case 2: 
            case 4: {
                this.keyType = dh.keyType;
                this.publicKey = new byte[dh.publicKey.length];
                System.arraycopy(dh.publicKey, 0, this.publicKey, 0, this.publicKey.length);
            }
        }
    }

    @Override
    public void specifyPeer(DHState local) {
        if (!(local instanceof NewHopeDHState)) {
            return;
        }
        this.clearKey();
        this.keyType = ((NewHopeDHState)local).keyType == KeyType.AlicePrivate ? KeyType.BobPublic : KeyType.AlicePublic;
    }

    static enum KeyType {
        None,
        AlicePrivate,
        AlicePublic,
        BobPrivate,
        BobPublic,
        BobCalculated;

    }

    private class NewHopeWithPrivateKey
    extends NewHopeTor {
        byte[] randomData;

        public NewHopeWithPrivateKey(byte[] randomData) {
            this.randomData = randomData;
        }

        @Override
        protected void randombytes(byte[] buffer) {
            System.arraycopy(this.randomData, 0, buffer, 0, buffer.length);
        }
    }
}

