/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.cds2;

import java.time.Instant;
import org.signal.libsignal.cds2.AttestationDataException;
import org.signal.libsignal.cds2.Cds2CommunicationFailureException;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;

public class Cds2Client
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    public Cds2Client(byte[] mrenclave, byte[] attestationMsg, Instant currentInstant) throws AttestationDataException {
        this.unsafeHandle = Native.Cds2ClientState_New(mrenclave, attestationMsg, currentInstant.toEpochMilli());
    }

    protected void finalize() {
        Native.Cds2ClientState_Destroy(this.unsafeHandle);
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    public byte[] initialRequest() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.Cds2ClientState_InitialRequest(guard.nativeHandle());
            return byArray;
        }
    }

    public void completeHandshake(byte[] handshakeResponse) throws Cds2CommunicationFailureException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            Native.Cds2ClientState_CompleteHandshake(guard.nativeHandle(), handshakeResponse);
        }
    }

    public byte[] establishedSend(byte[] plaintextToSend) throws Cds2CommunicationFailureException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.Cds2ClientState_EstablishedSend(guard.nativeHandle(), plaintextToSend);
            return byArray;
        }
    }

    public byte[] establishedRecv(byte[] receivedCiphertext) throws Cds2CommunicationFailureException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.Cds2ClientState_EstablishedRecv(guard.nativeHandle(), receivedCiphertext);
            return byArray;
        }
    }
}

