/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata;

import java.util.Optional;
import org.signal.libsignal.metadata.protocol.UnidentifiedSenderMessageContent;

public abstract class ProtocolException
extends Exception {
    private final Optional<UnidentifiedSenderMessageContent> content;
    private final String sender;
    private final int senderDevice;

    public ProtocolException(Exception e, String sender, int senderDevice) {
        super(e);
        this.content = Optional.empty();
        this.sender = sender;
        this.senderDevice = senderDevice;
    }

    ProtocolException(Exception e, UnidentifiedSenderMessageContent content) {
        super(e);
        this.content = Optional.of(content);
        this.sender = content.getSenderCertificate().getSender();
        this.senderDevice = content.getSenderCertificate().getSenderDeviceId();
    }

    public Optional<UnidentifiedSenderMessageContent> getUnidentifiedSenderMessageContent() {
        return this.content;
    }

    public String getSender() {
        return this.sender;
    }

    public int getSenderDevice() {
        return this.senderDevice;
    }

    public int getContentHint() {
        if (this.content.isPresent()) {
            return this.content.get().getContentHint();
        }
        return 0;
    }

    public Optional<byte[]> getGroupId() {
        if (this.content.isPresent()) {
            return this.content.get().getGroupId();
        }
        return Optional.empty();
    }
}

