/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import java.util.Optional;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.ServerCertificate;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class SenderCertificate
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.SenderCertificate_Destroy(this.unsafeHandle);
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    public SenderCertificate(byte[] serialized) throws InvalidCertificateException {
        try {
            this.unsafeHandle = Native.SenderCertificate_Deserialize(serialized);
        }
        catch (Exception e) {
            throw new InvalidCertificateException(e);
        }
    }

    public SenderCertificate(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    public ServerCertificate getSigner() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ServerCertificate serverCertificate = new ServerCertificate(Native.SenderCertificate_GetServerCertificate(guard.nativeHandle()));
            return serverCertificate;
        }
    }

    public ECPublicKey getKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ECPublicKey eCPublicKey = new ECPublicKey(Native.SenderCertificate_GetKey(guard.nativeHandle()));
            return eCPublicKey;
        }
    }

    public int getSenderDeviceId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.SenderCertificate_GetDeviceId(guard.nativeHandle());
            return n;
        }
    }

    public String getSenderUuid() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            String string = Native.SenderCertificate_GetSenderUuid(guard.nativeHandle());
            return string;
        }
    }

    public Optional<String> getSenderE164() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            Optional<String> optional = Optional.ofNullable(Native.SenderCertificate_GetSenderE164(guard.nativeHandle()));
            return optional;
        }
    }

    public String getSender() {
        return this.getSenderE164().orElseGet(this::getSenderUuid);
    }

    public long getExpiration() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            long l = Native.SenderCertificate_GetExpiration(guard.nativeHandle());
            return l;
        }
    }

    public byte[] getSerialized() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.SenderCertificate_GetSerialized(guard.nativeHandle());
            return byArray;
        }
    }

    public byte[] getCertificate() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.SenderCertificate_GetCertificate(guard.nativeHandle());
            return byArray;
        }
    }

    public byte[] getSignature() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.SenderCertificate_GetSignature(guard.nativeHandle());
            return byArray;
        }
    }
}

