/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.groups;

import java.util.UUID;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.groups.state.SenderKeyStore;
import org.signal.libsignal.protocol.message.SenderKeyDistributionMessage;

public class GroupSessionBuilder {
    private final SenderKeyStore senderKeyStore;

    public GroupSessionBuilder(SenderKeyStore senderKeyStore) {
        this.senderKeyStore = senderKeyStore;
    }

    public void process(SignalProtocolAddress sender, SenderKeyDistributionMessage senderKeyDistributionMessage) {
        try (NativeHandleGuard senderGuard = new NativeHandleGuard(sender);
             NativeHandleGuard skdmGuard = new NativeHandleGuard(senderKeyDistributionMessage);){
            Native.GroupSessionBuilder_ProcessSenderKeyDistributionMessage(senderGuard.nativeHandle(), skdmGuard.nativeHandle(), this.senderKeyStore, null);
        }
    }

    public SenderKeyDistributionMessage create(SignalProtocolAddress sender, UUID distributionId) {
        try (NativeHandleGuard senderGuard = new NativeHandleGuard(sender);){
            SenderKeyDistributionMessage senderKeyDistributionMessage = new SenderKeyDistributionMessage(Native.GroupSessionBuilder_CreateSenderKeyDistributionMessage(senderGuard.nativeHandle(), distributionId, this.senderKeyStore, null));
            return senderKeyDistributionMessage;
        }
    }
}

