/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.receipts;

import java.security.SecureRandom;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.ServerPublicParams;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredential;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialPresentation;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialRequestContext;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialResponse;
import org.signal.libsignal.zkgroup.receipts.ReceiptSerial;

public class ClientZkReceiptOperations {
    private final ServerPublicParams serverPublicParams;

    public ClientZkReceiptOperations(ServerPublicParams serverPublicParams) {
        this.serverPublicParams = serverPublicParams;
    }

    public ReceiptCredentialRequestContext createReceiptCredentialRequestContext(ReceiptSerial receiptSerial) throws VerificationFailedException {
        return this.createReceiptCredentialRequestContext(new SecureRandom(), receiptSerial);
    }

    public ReceiptCredentialRequestContext createReceiptCredentialRequestContext(SecureRandom secureRandom, ReceiptSerial receiptSerial) throws VerificationFailedException {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.ServerPublicParams_CreateReceiptCredentialRequestContextDeterministic(this.serverPublicParams.getInternalContentsForJNI(), random, receiptSerial.getInternalContentsForJNI());
        try {
            return new ReceiptCredentialRequestContext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ReceiptCredential receiveReceiptCredential(ReceiptCredentialRequestContext receiptCredentialRequestContext, ReceiptCredentialResponse receiptCredentialResponse) throws VerificationFailedException {
        byte[] newContents = Native.ServerPublicParams_ReceiveReceiptCredential(this.serverPublicParams.getInternalContentsForJNI(), receiptCredentialRequestContext.getInternalContentsForJNI(), receiptCredentialResponse.getInternalContentsForJNI());
        try {
            return new ReceiptCredential(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ReceiptCredentialPresentation createReceiptCredentialPresentation(ReceiptCredential receiptCredential) throws VerificationFailedException {
        return this.createReceiptCredentialPresentation(new SecureRandom(), receiptCredential);
    }

    public ReceiptCredentialPresentation createReceiptCredentialPresentation(SecureRandom secureRandom, ReceiptCredential receiptCredential) throws VerificationFailedException {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.ServerPublicParams_CreateReceiptCredentialPresentationDeterministic(this.serverPublicParams.getInternalContentsForJNI(), random, receiptCredential.getInternalContentsForJNI());
        try {
            return new ReceiptCredentialPresentation(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

