/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class PreKeyBundle
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.PreKeyBundle_Destroy(this.unsafeHandle);
    }

    public PreKeyBundle(int registrationId, int deviceId, int preKeyId, ECPublicKey preKeyPublic, int signedPreKeyId, ECPublicKey signedPreKeyPublic, byte[] signedPreKeySignature, IdentityKey identityKey) {
        try (NativeHandleGuard preKeyPublicGuard = new NativeHandleGuard(preKeyPublic);
             NativeHandleGuard signedPreKeyPublicGuard = new NativeHandleGuard(signedPreKeyPublic);
             NativeHandleGuard identityKeyGuard = new NativeHandleGuard(identityKey.getPublicKey());){
            this.unsafeHandle = Native.PreKeyBundle_New(registrationId, deviceId, preKeyId, preKeyPublicGuard.nativeHandle(), signedPreKeyId, signedPreKeyPublicGuard.nativeHandle(), signedPreKeySignature, identityKeyGuard.nativeHandle());
        }
    }

    public int getDeviceId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.PreKeyBundle_GetDeviceId(guard.nativeHandle());
            return n;
        }
    }

    public int getPreKeyId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.PreKeyBundle_GetPreKeyId(guard.nativeHandle());
            return n;
        }
    }

    public ECPublicKey getPreKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            long handle = Native.PreKeyBundle_GetPreKeyPublic(guard.nativeHandle());
            if (handle != 0L) {
                ECPublicKey eCPublicKey = new ECPublicKey(handle);
                return eCPublicKey;
            }
            ECPublicKey eCPublicKey = null;
            return eCPublicKey;
        }
    }

    public int getSignedPreKeyId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.PreKeyBundle_GetSignedPreKeyId(guard.nativeHandle());
            return n;
        }
    }

    public ECPublicKey getSignedPreKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ECPublicKey eCPublicKey = new ECPublicKey(Native.PreKeyBundle_GetSignedPreKeyPublic(guard.nativeHandle()));
            return eCPublicKey;
        }
    }

    public byte[] getSignedPreKeySignature() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.PreKeyBundle_GetSignedPreKeySignature(guard.nativeHandle());
            return byArray;
        }
    }

    public IdentityKey getIdentityKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            IdentityKey identityKey = new IdentityKey(new ECPublicKey(Native.PreKeyBundle_GetIdentityKey(guard.nativeHandle())));
            return identityKey;
        }
    }

    public int getRegistrationId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.PreKeyBundle_GetRegistrationId(guard.nativeHandle());
            return n;
        }
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }
}

