/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class SignedPreKeyRecord
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.SignedPreKeyRecord_Destroy(this.unsafeHandle);
    }

    public SignedPreKeyRecord(int id, long timestamp, ECKeyPair keyPair, byte[] signature) {
        try (NativeHandleGuard publicGuard = new NativeHandleGuard(keyPair.getPublicKey());
             NativeHandleGuard privateGuard = new NativeHandleGuard(keyPair.getPrivateKey());){
            this.unsafeHandle = Native.SignedPreKeyRecord_New(id, timestamp, publicGuard.nativeHandle(), privateGuard.nativeHandle(), signature);
        }
    }

    public SignedPreKeyRecord(byte[] serialized) throws InvalidMessageException {
        this.unsafeHandle = Native.SignedPreKeyRecord_Deserialize(serialized);
    }

    public int getId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.SignedPreKeyRecord_GetId(guard.nativeHandle());
            return n;
        }
    }

    public long getTimestamp() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            long l = Native.SignedPreKeyRecord_GetTimestamp(guard.nativeHandle());
            return l;
        }
    }

    public ECKeyPair getKeyPair() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ECPublicKey publicKey = new ECPublicKey(Native.SignedPreKeyRecord_GetPublicKey(guard.nativeHandle()));
            ECPrivateKey privateKey = new ECPrivateKey(Native.SignedPreKeyRecord_GetPrivateKey(guard.nativeHandle()));
            ECKeyPair eCKeyPair = new ECKeyPair(publicKey, privateKey);
            return eCKeyPair;
        }
    }

    public byte[] getSignature() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.SignedPreKeyRecord_GetSignature(guard.nativeHandle());
            return byArray;
        }
    }

    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.SignedPreKeyRecord_GetSerialized(guard.nativeHandle());
            return byArray;
        }
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }
}

