/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.groups;

import java.security.SecureRandom;
import java.util.UUID;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.groups.ProfileKeyCiphertext;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;

public class ClientZkGroupCipher {
    private final GroupSecretParams groupSecretParams;

    public ClientZkGroupCipher(GroupSecretParams groupSecretParams) {
        this.groupSecretParams = groupSecretParams;
    }

    public UuidCiphertext encryptUuid(UUID uuid) {
        byte[] newContents = Native.GroupSecretParams_EncryptUuid(this.groupSecretParams.getInternalContentsForJNI(), uuid);
        try {
            return new UuidCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public UUID decryptUuid(UuidCiphertext uuidCiphertext) throws VerificationFailedException {
        return Native.GroupSecretParams_DecryptUuid(this.groupSecretParams.getInternalContentsForJNI(), uuidCiphertext.getInternalContentsForJNI());
    }

    public ProfileKeyCiphertext encryptProfileKey(ProfileKey profileKey, UUID uuid) {
        byte[] newContents = Native.GroupSecretParams_EncryptProfileKey(this.groupSecretParams.getInternalContentsForJNI(), profileKey.getInternalContentsForJNI(), uuid);
        try {
            return new ProfileKeyCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ProfileKey decryptProfileKey(ProfileKeyCiphertext profileKeyCiphertext, UUID uuid) throws VerificationFailedException {
        byte[] newContents = Native.GroupSecretParams_DecryptProfileKey(this.groupSecretParams.getInternalContentsForJNI(), profileKeyCiphertext.getInternalContentsForJNI(), uuid);
        try {
            return new ProfileKey(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] encryptBlob(byte[] plaintext) throws VerificationFailedException {
        return this.encryptBlob(new SecureRandom(), plaintext);
    }

    public byte[] encryptBlob(SecureRandom secureRandom, byte[] plaintext) throws VerificationFailedException {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        return Native.GroupSecretParams_EncryptBlobWithPaddingDeterministic(this.groupSecretParams.getInternalContentsForJNI(), random, plaintext, 0);
    }

    public byte[] decryptBlob(byte[] blobCiphertext) throws VerificationFailedException {
        return Native.GroupSecretParams_DecryptBlobWithPadding(this.groupSecretParams.getInternalContentsForJNI(), blobCiphertext);
    }
}

