/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.profiles;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.ProfileKeyCiphertext;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class PniCredentialPresentation
extends ByteArray {
    public PniCredentialPresentation(byte[] contents) throws InvalidInputException {
        super(contents);
        Native.PniCredentialPresentation_CheckValidContents(contents);
    }

    public UuidCiphertext getAciCiphertext() {
        byte[] newContents = Native.PniCredentialPresentation_GetAciCiphertext(this.contents);
        try {
            return new UuidCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public UuidCiphertext getPniCiphertext() {
        byte[] newContents = Native.PniCredentialPresentation_GetPniCiphertext(this.contents);
        try {
            return new UuidCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ProfileKeyCiphertext getProfileKeyCiphertext() {
        byte[] newContents = Native.PniCredentialPresentation_GetProfileKeyCiphertext(this.contents);
        try {
            return new ProfileKeyCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Version getVersion() {
        if (this.contents[0] == 0) {
            return Version.V1;
        }
        if (this.contents[0] == 1) {
            return Version.V2;
        }
        return Version.UNKNOWN;
    }

    public static enum Version {
        V1,
        V2,
        UNKNOWN;

    }
}

