/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.profiles;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.ProfileKeyCiphertext;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class ProfileKeyCredentialPresentation
extends ByteArray {
    public ProfileKeyCredentialPresentation(byte[] contents) throws InvalidInputException {
        super(contents);
        Native.ProfileKeyCredentialPresentation_CheckValidContents(contents);
    }

    public UuidCiphertext getUuidCiphertext() {
        byte[] newContents = Native.ProfileKeyCredentialPresentation_GetUuidCiphertext(this.contents);
        try {
            return new UuidCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ProfileKeyCiphertext getProfileKeyCiphertext() {
        byte[] newContents = Native.ProfileKeyCredentialPresentation_GetProfileKeyCiphertext(this.contents);
        try {
            return new ProfileKeyCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] getStructurallyValidV1PresentationBytes() {
        return Native.ProfileKeyCredentialPresentation_GetStructurallyValidV1PresentationBytes(this.contents);
    }

    public Version getVersion() {
        switch (this.contents[0]) {
            case 0: {
                return Version.V1;
            }
            case 1: {
                return Version.V2;
            }
            case 2: {
                return Version.V3;
            }
        }
        return Version.UNKNOWN;
    }

    public static enum Version {
        V1,
        V2,
        V3,
        UNKNOWN;

    }
}

