/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.auth;

import java.security.SecureRandom;
import java.time.Instant;
import java.util.UUID;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.ServerSecretParams;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.auth.AuthCredentialPresentation;
import org.signal.libsignal.zkgroup.auth.AuthCredentialResponse;
import org.signal.libsignal.zkgroup.auth.AuthCredentialWithPniResponse;
import org.signal.libsignal.zkgroup.groups.GroupPublicParams;

public class ServerZkAuthOperations {
    private final ServerSecretParams serverSecretParams;

    public ServerZkAuthOperations(ServerSecretParams serverSecretParams) {
        this.serverSecretParams = serverSecretParams;
    }

    public AuthCredentialResponse issueAuthCredential(UUID uuid, int redemptionTime) {
        return this.issueAuthCredential(new SecureRandom(), uuid, redemptionTime);
    }

    public AuthCredentialResponse issueAuthCredential(SecureRandom secureRandom, UUID uuid, int redemptionTime) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.ServerSecretParams_IssueAuthCredentialDeterministic(this.serverSecretParams.getInternalContentsForJNI(), random, uuid, redemptionTime);
        try {
            return new AuthCredentialResponse(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public AuthCredentialWithPniResponse issueAuthCredentialWithPni(UUID aci, UUID pni, Instant redemptionTime) {
        return this.issueAuthCredentialWithPni(new SecureRandom(), aci, pni, redemptionTime);
    }

    public AuthCredentialWithPniResponse issueAuthCredentialWithPni(SecureRandom secureRandom, UUID aci, UUID pni, Instant redemptionTime) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.ServerSecretParams_IssueAuthCredentialWithPniDeterministic(this.serverSecretParams.getInternalContentsForJNI(), random, aci, pni, redemptionTime.getEpochSecond());
        try {
            return new AuthCredentialWithPniResponse(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void verifyAuthCredentialPresentation(GroupPublicParams groupPublicParams, AuthCredentialPresentation authCredentialPresentation) throws VerificationFailedException {
        this.verifyAuthCredentialPresentation(groupPublicParams, authCredentialPresentation, Instant.now());
    }

    public void verifyAuthCredentialPresentation(GroupPublicParams groupPublicParams, AuthCredentialPresentation authCredentialPresentation, Instant currentTime) throws VerificationFailedException {
        Native.ServerSecretParams_VerifyAuthCredentialPresentation(this.serverSecretParams.getInternalContentsForJNI(), groupPublicParams.getInternalContentsForJNI(), authCredentialPresentation.getInternalContentsForJNI(), currentTime.getEpochSecond());
    }
}

