/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.profiles;

import java.util.UUID;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.internal.ByteArray;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyCommitment;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyVersion;

public final class ProfileKey
extends ByteArray {
    public ProfileKey(byte[] contents) throws InvalidInputException {
        super(contents);
        Native.ProfileKey_CheckValidContents(contents);
    }

    public ProfileKeyCommitment getCommitment(UUID uuid) {
        byte[] newContents = Native.ProfileKey_GetCommitment(this.contents, uuid);
        try {
            return new ProfileKeyCommitment(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ProfileKeyVersion getProfileKeyVersion(UUID uuid) {
        byte[] newContents = Native.ProfileKey_GetProfileKeyVersion(this.contents, uuid);
        try {
            return new ProfileKeyVersion(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] deriveAccessKey() {
        return Native.ProfileKey_DeriveAccessKey(this.contents);
    }
}

