/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.metadata.InvalidMetadataMessageException;
import org.signal.libsignal.metadata.InvalidMetadataVersionException;
import org.signal.libsignal.metadata.ProtocolDuplicateMessageException;
import org.signal.libsignal.metadata.ProtocolInvalidKeyException;
import org.signal.libsignal.metadata.ProtocolInvalidKeyIdException;
import org.signal.libsignal.metadata.ProtocolInvalidMessageException;
import org.signal.libsignal.metadata.ProtocolInvalidVersionException;
import org.signal.libsignal.metadata.ProtocolLegacyMessageException;
import org.signal.libsignal.metadata.ProtocolNoSessionException;
import org.signal.libsignal.metadata.ProtocolUntrustedIdentityException;
import org.signal.libsignal.metadata.SelfSendException;
import org.signal.libsignal.metadata.certificate.CertificateValidator;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.protocol.UnidentifiedSenderMessageContent;
import org.signal.libsignal.protocol.DuplicateMessageException;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidRegistrationIdException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SessionCipher;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.UntrustedIdentityException;
import org.signal.libsignal.protocol.groups.GroupCipher;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.message.PreKeySignalMessage;
import org.signal.libsignal.protocol.message.SignalMessage;
import org.signal.libsignal.protocol.state.SessionRecord;
import org.signal.libsignal.protocol.state.SignalProtocolStore;

public class SealedSessionCipher {
    private static final String TAG = SealedSessionCipher.class.getSimpleName();
    private final SignalProtocolStore signalProtocolStore;
    private final String localE164Address;
    private final String localUuidAddress;
    private final int localDeviceId;

    public SealedSessionCipher(SignalProtocolStore signalProtocolStore, UUID localUuid, String localE164Address, int localDeviceId) {
        this.signalProtocolStore = signalProtocolStore;
        this.localUuidAddress = localUuid.toString();
        this.localE164Address = localE164Address;
        this.localDeviceId = localDeviceId;
    }

    public byte[] encrypt(SignalProtocolAddress destinationAddress, SenderCertificate senderCertificate, byte[] paddedPlaintext) throws InvalidKeyException, UntrustedIdentityException {
        try (NativeHandleGuard addressGuard = new NativeHandleGuard(destinationAddress);){
            CiphertextMessage message = Native.SessionCipher_EncryptMessage(paddedPlaintext, addressGuard.nativeHandle(), this.signalProtocolStore, this.signalProtocolStore);
            UnidentifiedSenderMessageContent content = new UnidentifiedSenderMessageContent(message, senderCertificate, 0, Optional.empty());
            byte[] byArray = this.encrypt(destinationAddress, content);
            return byArray;
        }
    }

    public byte[] encrypt(SignalProtocolAddress destinationAddress, UnidentifiedSenderMessageContent content) throws InvalidKeyException, UntrustedIdentityException {
        try (NativeHandleGuard addressGuard = new NativeHandleGuard(destinationAddress);){
            NativeHandleGuard contentGuard = new NativeHandleGuard(content);
            try {
                byte[] byArray = Native.SealedSessionCipher_Encrypt(addressGuard.nativeHandle(), contentGuard.nativeHandle(), this.signalProtocolStore);
                contentGuard.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    contentGuard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public byte[] multiRecipientEncrypt(List<SignalProtocolAddress> recipients, UnidentifiedSenderMessageContent content) throws InvalidKeyException, InvalidRegistrationIdException, NoSessionException, UntrustedIdentityException {
        List<SessionRecord> recipientSessions = this.signalProtocolStore.loadExistingSessions(recipients);
        long[] recipientHandles = new long[recipients.size()];
        int i = 0;
        for (SignalProtocolAddress signalProtocolAddress : recipients) {
            recipientHandles[i] = signalProtocolAddress.unsafeNativeHandleWithoutGuard();
            ++i;
        }
        long[] recipientSessionHandles = new long[recipientSessions.size()];
        i = 0;
        for (SessionRecord nextSession : recipientSessions) {
            recipientSessionHandles[i] = nextSession.unsafeNativeHandleWithoutGuard();
            ++i;
        }
        try (NativeHandleGuard nativeHandleGuard = new NativeHandleGuard(content);){
            byte[] result = Native.SealedSessionCipher_MultiRecipientEncrypt(recipientHandles, recipientSessionHandles, nativeHandleGuard.nativeHandle(), this.signalProtocolStore);
            Native.keepAlive(recipients);
            Native.keepAlive(recipientSessions);
            byte[] byArray = result;
            return byArray;
        }
    }

    static byte[] multiRecipientMessageForSingleRecipient(byte[] message) {
        try {
            return Native.SealedSessionCipher_MultiRecipientMessageForSingleRecipient(message);
        }
        catch (Exception e) {
            if (e instanceof InvalidVersionException) {
                throw new AssertionError((Object)e);
            }
            throw e;
        }
    }

    public DecryptionResult decrypt(CertificateValidator validator, byte[] ciphertext, long timestamp) throws InvalidMetadataMessageException, InvalidMetadataVersionException, ProtocolInvalidMessageException, ProtocolInvalidKeyException, ProtocolNoSessionException, ProtocolLegacyMessageException, ProtocolInvalidVersionException, ProtocolDuplicateMessageException, ProtocolInvalidKeyIdException, ProtocolUntrustedIdentityException, SelfSendException {
        UnidentifiedSenderMessageContent content;
        try {
            content = new UnidentifiedSenderMessageContent(Native.SealedSessionCipher_DecryptToUsmc(ciphertext, this.signalProtocolStore));
            validator.validate(content.getSenderCertificate(), timestamp);
        }
        catch (Exception e) {
            throw new InvalidMetadataMessageException(e);
        }
        boolean isLocalE164 = this.localE164Address != null && this.localE164Address.equals(content.getSenderCertificate().getSenderE164().orElse(null));
        boolean isLocalUuid = this.localUuidAddress.equals(content.getSenderCertificate().getSenderUuid());
        if ((isLocalE164 || isLocalUuid) && content.getSenderCertificate().getSenderDeviceId() == this.localDeviceId) {
            throw new SelfSendException();
        }
        try {
            return new DecryptionResult(content.getSenderCertificate().getSenderUuid(), content.getSenderCertificate().getSenderE164(), content.getSenderCertificate().getSenderDeviceId(), content.getType(), content.getGroupId(), this.decrypt(content));
        }
        catch (InvalidMessageException e) {
            throw new ProtocolInvalidMessageException(e, content);
        }
        catch (InvalidKeyException e) {
            throw new ProtocolInvalidKeyException(e, content);
        }
        catch (NoSessionException e) {
            throw new ProtocolNoSessionException(e, content);
        }
        catch (LegacyMessageException e) {
            throw new ProtocolLegacyMessageException(e, content);
        }
        catch (InvalidVersionException e) {
            throw new ProtocolInvalidVersionException(e, content);
        }
        catch (DuplicateMessageException e) {
            throw new ProtocolDuplicateMessageException(e, content);
        }
        catch (InvalidKeyIdException e) {
            throw new ProtocolInvalidKeyIdException(e, content);
        }
        catch (UntrustedIdentityException e) {
            throw new ProtocolUntrustedIdentityException(e, content);
        }
    }

    public int getSessionVersion(SignalProtocolAddress remoteAddress) {
        return new SessionCipher(this.signalProtocolStore, remoteAddress).getSessionVersion();
    }

    public int getRemoteRegistrationId(SignalProtocolAddress remoteAddress) {
        return new SessionCipher(this.signalProtocolStore, remoteAddress).getRemoteRegistrationId();
    }

    private byte[] decrypt(UnidentifiedSenderMessageContent message) throws InvalidVersionException, InvalidMessageException, InvalidKeyException, DuplicateMessageException, InvalidKeyIdException, UntrustedIdentityException, LegacyMessageException, NoSessionException {
        SignalProtocolAddress sender = new SignalProtocolAddress(message.getSenderCertificate().getSenderUuid(), message.getSenderCertificate().getSenderDeviceId());
        switch (message.getType()) {
            case 2: {
                return new SessionCipher(this.signalProtocolStore, sender).decrypt(new SignalMessage(message.getContent()));
            }
            case 3: {
                return new SessionCipher(this.signalProtocolStore, sender).decrypt(new PreKeySignalMessage(message.getContent()));
            }
            case 7: {
                return new GroupCipher(this.signalProtocolStore, sender).decrypt(message.getContent());
            }
            case 8: {
                return Native.PlaintextContent_DeserializeAndGetContent(message.getContent());
            }
        }
        throw new InvalidMessageException("Unknown type: " + message.getType());
    }

    public static class DecryptionResult {
        private final String senderUuid;
        private final Optional<String> senderE164;
        private final int deviceId;
        private final int messageType;
        private final Optional<byte[]> groupId;
        private final byte[] paddedMessage;

        private DecryptionResult(String senderUuid, Optional<String> senderE164, int deviceId, int messageType, Optional<byte[]> groupId, byte[] paddedMessage) {
            this.senderUuid = senderUuid;
            this.senderE164 = senderE164;
            this.deviceId = deviceId;
            this.messageType = messageType;
            this.groupId = groupId;
            this.paddedMessage = paddedMessage;
        }

        public String getSenderUuid() {
            return this.senderUuid;
        }

        public ServiceId.Aci getSenderAci() {
            try {
                return ServiceId.Aci.parseFromString(this.getSenderUuid());
            }
            catch (ServiceId.InvalidServiceIdException e) {
                return null;
            }
        }

        public Optional<String> getSenderE164() {
            return this.senderE164;
        }

        public int getDeviceId() {
            return this.deviceId;
        }

        public int getCiphertextMessageType() {
            return this.messageType;
        }

        public byte[] getPaddedMessage() {
            return this.paddedMessage;
        }

        public Optional<byte[]> getGroupId() {
            return this.groupId;
        }
    }
}

