/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class IdentityKeyPair {
    private final IdentityKey publicKey;
    private final ECPrivateKey privateKey;

    public IdentityKeyPair(IdentityKey publicKey, ECPrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public IdentityKeyPair(byte[] serialized) {
        long[] tuple = Native.IdentityKeyPair_Deserialize(serialized);
        long publicKeyHandle = tuple[0];
        long privateKeyHandle = tuple[1];
        this.publicKey = new IdentityKey(publicKeyHandle);
        this.privateKey = new ECPrivateKey(privateKeyHandle);
    }

    public static IdentityKeyPair generate() {
        ECKeyPair keyPair = Curve.generateKeyPair();
        ECPrivateKey privateKey = keyPair.getPrivateKey();
        ECPublicKey publicKey = keyPair.getPublicKey();
        return new IdentityKeyPair(new IdentityKey(publicKey), privateKey);
    }

    public IdentityKey getPublicKey() {
        return this.publicKey;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public byte[] serialize() {
        try (NativeHandleGuard publicKey = new NativeHandleGuard(this.publicKey.getPublicKey());){
            NativeHandleGuard privateKey = new NativeHandleGuard(this.privateKey);
            try {
                byte[] byArray = Native.IdentityKeyPair_Serialize(publicKey.nativeHandle(), privateKey.nativeHandle());
                privateKey.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    privateKey.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] signAlternateIdentity(IdentityKey other) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

