/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.incrementalmac;

import java.io.IOException;
import java.io.InputStream;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.incrementalmac.ChunkSizeChoice;
import org.signal.libsignal.protocol.incrementalmac.InvalidMacException;

public final class IncrementalMacInputStream
extends InputStream {
    private final long validatingMac;
    private final InputStream inner;
    private boolean closed = false;

    public IncrementalMacInputStream(InputStream inner, byte[] key, ChunkSizeChoice sizeChoice, byte[] digest) {
        int chunkSize = sizeChoice.getSizeInBytes();
        this.validatingMac = Native.ValidatingMac_Initialize(key, chunkSize, digest);
        this.inner = inner;
    }

    @Override
    public int read() throws IOException {
        int read = this.inner.read();
        byte[] bytes = new byte[]{(byte)read};
        int bytesLength = read == -1 ? -1 : 1;
        return this.handleRead(bytes, 0, bytesLength);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int read = this.inner.read(bytes, offset, length);
        return this.handleRead(bytes, offset, read);
    }

    private int handleRead(byte[] bytes, int offset, int read) throws IOException {
        boolean isValid;
        boolean bl = isValid = read == -1 ? Native.ValidatingMac_Finalize(this.validatingMac) : Native.ValidatingMac_Update(this.validatingMac, bytes, offset, read);
        if (!isValid) {
            throw new InvalidMacException();
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.inner.close();
        Native.ValidatingMac_Destroy(this.validatingMac);
        this.closed = true;
    }
}

