/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol;

import java.time.Instant;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.UntrustedIdentityException;
import org.signal.libsignal.protocol.state.IdentityKeyStore;
import org.signal.libsignal.protocol.state.PreKeyBundle;
import org.signal.libsignal.protocol.state.PreKeyStore;
import org.signal.libsignal.protocol.state.SessionStore;
import org.signal.libsignal.protocol.state.SignalProtocolStore;
import org.signal.libsignal.protocol.state.SignedPreKeyStore;

public class SessionBuilder {
    private static final String TAG = SessionBuilder.class.getSimpleName();
    private final SessionStore sessionStore;
    private final PreKeyStore preKeyStore;
    private final SignedPreKeyStore signedPreKeyStore;
    private final IdentityKeyStore identityKeyStore;
    private final SignalProtocolAddress remoteAddress;

    public SessionBuilder(SessionStore sessionStore, PreKeyStore preKeyStore, SignedPreKeyStore signedPreKeyStore, IdentityKeyStore identityKeyStore, SignalProtocolAddress remoteAddress) {
        this.sessionStore = sessionStore;
        this.preKeyStore = preKeyStore;
        this.signedPreKeyStore = signedPreKeyStore;
        this.identityKeyStore = identityKeyStore;
        this.remoteAddress = remoteAddress;
    }

    public SessionBuilder(SignalProtocolStore store, SignalProtocolAddress remoteAddress) {
        this(store, store, store, store, remoteAddress);
    }

    public void process(PreKeyBundle preKey) throws InvalidKeyException, UntrustedIdentityException {
        this.process(preKey, Instant.now());
    }

    public void process(PreKeyBundle preKey, Instant now) throws InvalidKeyException, UntrustedIdentityException {
        try (NativeHandleGuard preKeyGuard = new NativeHandleGuard(preKey);
             NativeHandleGuard remoteAddressGuard = new NativeHandleGuard(this.remoteAddress);){
            Native.SessionBuilder_ProcessPreKeyBundle(preKeyGuard.nativeHandle(), remoteAddressGuard.nativeHandle(), this.sessionStore, this.identityKeyStore, now.toEpochMilli());
        }
    }
}

