/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.incrementalmac;

import java.io.IOException;
import java.io.InputStream;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.incrementalmac.ChunkSizeChoice;
import org.signal.libsignal.protocol.incrementalmac.InvalidMacException;

public final class IncrementalMacInputStream
extends InputStream {
    private final long validatingMac;
    private final InputStream inner;
    private boolean closed = false;
    private byte[] currentChunk;
    private int readPos;
    private int writePos;

    public IncrementalMacInputStream(InputStream inner, byte[] key, ChunkSizeChoice sizeChoice, byte[] digest) {
        int chunkSize = sizeChoice.getSizeInBytes();
        this.readPos = 0;
        this.writePos = 0;
        this.currentChunk = new byte[chunkSize];
        this.validatingMac = Native.ValidatingMac_Initialize(key, chunkSize, digest);
        this.inner = inner;
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int read = this.readInternal(bytes, 0, 1);
        return read < 0 ? -1 : bytes[0];
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.readInternal(bytes, offset, length);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.inner.close();
        Native.ValidatingMac_Destroy(this.validatingMac);
        this.closed = true;
    }

    private int readInternal(byte[] bytes, int offset, int requestedLen) throws IOException {
        if (this.readPos == this.writePos) {
            int bytesRead = this.readBuffer(this.inner, this.currentChunk);
            if (bytesRead == 0) {
                return -1;
            }
            this.writePos = bytesRead;
            this.readPos = 0;
            this.validateChunk();
        }
        int availableToRead = this.writePos - this.readPos;
        int bytesToRead = Math.min(availableToRead, requestedLen);
        System.arraycopy(this.currentChunk, this.readPos, bytes, offset, bytesToRead);
        this.readPos += bytesToRead;
        return bytesToRead;
    }

    private void validateChunk() throws IOException {
        int validBytes = Native.ValidatingMac_Update(this.validatingMac, this.currentChunk, 0, this.writePos);
        if (this.writePos < this.currentChunk.length) {
            validBytes += Native.ValidatingMac_Finalize(this.validatingMac);
        }
        if (validBytes < 0) {
            throw new InvalidMacException();
        }
    }

    private int readBuffer(InputStream src, byte[] bytes) throws IOException {
        int totalReadBytes;
        int readBytes;
        for (totalReadBytes = 0; totalReadBytes < bytes.length && (readBytes = src.read(bytes, totalReadBytes, bytes.length - totalReadBytes)) >= 0; totalReadBytes += readBytes) {
        }
        return totalReadBytes;
    }
}

